/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.MutableNavigationalState;
import org.apache.jetspeed.decoration.PageActionAccess;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePortletAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(ChangePortletAction.class);
    protected String action;
    protected Map validWindowStates = new HashMap();
    protected Map validPortletModes = new HashMap();

    public ChangePortletAction(String template, String errorTemplate, String action) throws AJAXException {
        this(template, errorTemplate, action, null, null);
    }

    public ChangePortletAction(String template, String errorTemplate, String action, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) throws AJAXException {
        super(template, errorTemplate, pageManager, securityBehavior);
        String state;
        String mode;
        this.action = action;
        Iterator modes = JetspeedActions.getStandardPortletModes().iterator();
        while (modes.hasNext()) {
            mode = modes.next().toString();
            this.validPortletModes.put(mode, mode);
        }
        modes = JetspeedActions.getExtendedPortletModes().iterator();
        while (modes.hasNext()) {
            mode = modes.next().toString();
            this.validPortletModes.put(mode, mode);
        }
        Iterator states = JetspeedActions.getStandardWindowStates().iterator();
        while (states.hasNext()) {
            state = states.next().toString();
            this.validWindowStates.put(state, state);
        }
        states = JetspeedActions.getExtendedWindowStates().iterator();
        while (states.hasNext()) {
            state = states.next().toString();
            this.validWindowStates.put(state, state);
        }
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, true);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean runAction(RequestContext requestContext, Map resultMap, boolean batch) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", this.action);
            String fragmentId = this.getActionParameter(requestContext, "id");
            if (fragmentId == null) {
                throw new Exception("fragment id not provided");
            }
            resultMap.put("id", fragmentId);
            ContentPage page = requestContext.getPage();
            ContentFragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new Exception("fragment specified by id cannot be found");
            }
            String requestedState = this.getActionParameter(requestContext, "state");
            String requestedMode = this.getActionParameter(requestContext, "mode");
            if ("layout".equals(fragment.getType())) {
                if (!fragment.getId().equals(page.getRootFragment().getId())) {
                    throw new Exception("for layout fragments, change action applies to only to the root layout fragment (i.e. it does not apply to nested layout fragments)");
                }
                PageActionAccess pageActionAccess = (PageActionAccess)requestContext.getAttribute("org.apache.jetspeed.decoration.PageEditAccess");
                if (pageActionAccess == null) {
                    throw new Exception("cannot change action for root layout fragment due to null PageActionAccess object");
                }
                PortletWindow window = requestContext.getPortletWindow(fragment);
                if (!window.isValid()) {
                    throw new Exception("Failed to retrieve Portlet Definition for: " + fragment.getId() + ", " + fragment.getName());
                }
                PortletMode currentMode = requestContext.getPortalURL().getNavigationalState().getMode(window);
                WindowState currentState = requestContext.getPortalURL().getNavigationalState().getState(window);
                boolean requestedModeAlreadySet = false;
                if (requestedMode == null) {
                    requestedModeAlreadySet = true;
                } else if (requestedMode.equals(PortletMode.EDIT.toString())) {
                    if (pageActionAccess.isEditing()) {
                        requestedModeAlreadySet = true;
                    } else {
                        if (!pageActionAccess.isEditAllowed()) throw new Exception("permissions do no allow page edit");
                        pageActionAccess.setEditing(true);
                        resultMap.put("status", status);
                        resultMap.put("oldMode", currentMode.toString());
                        resultMap.put("mode", requestedMode);
                    }
                } else if (requestedMode.equals(PortletMode.VIEW.toString())) {
                    pageActionAccess.setEditing(false);
                    resultMap.put("status", status);
                    resultMap.put("oldMode", currentMode.toString());
                    resultMap.put("mode", requestedMode);
                } else {
                    requestedModeAlreadySet = true;
                }
                if (!requestedModeAlreadySet) return success;
                resultMap.put("status", status);
                resultMap.put("oldMode", currentMode.toString());
                resultMap.put("mode", currentMode.toString());
                return success;
            } else {
                if (requestedState == null && requestedMode == null) {
                    throw new Exception("portlet window state or mode not provided");
                }
                if (requestedState != null && !this.isValidWindowState(requestedState)) {
                    throw new Exception("portlet window state " + requestedState + " is not supported");
                }
                if (requestedMode != null && !this.isValidPortletMode(requestedMode)) {
                    throw new Exception("portlet mode " + requestedMode + " is not supported");
                }
                String oldState = fragment.getState();
                String oldMode = fragment.getMode();
                MutableNavigationalState navState = (MutableNavigationalState)requestContext.getPortalURL().getNavigationalState();
                PortletWindow portletWindow = requestContext.getPortletWindow(fragment);
                if (portletWindow != null) {
                    oldState = navState.getState(portletWindow).toString();
                    oldMode = navState.getMode(portletWindow).toString();
                    if (requestedState != null) {
                        navState.setState(portletWindow, new WindowState(requestedState));
                    }
                    if (requestedMode != null) {
                        navState.setMode(portletWindow, new PortletMode(requestedMode));
                    }
                    navState.sync(requestContext);
                }
                if (this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                    fragment.updateStateMode(requestedState, requestedMode);
                }
                resultMap.put("status", status);
                if (requestedState != null) {
                    resultMap.put("oldState", oldState);
                    resultMap.put("state", requestedState);
                }
                if (requestedMode == null) return success;
                resultMap.put("oldMode", oldMode);
                resultMap.put("mode", requestedMode);
            }
            return success;
        }
        catch (Exception e) {
            log.error("exception while changing portlet/page action", (Throwable)e);
            resultMap.put("reason", e.toString());
            return false;
        }
    }

    protected boolean isValidWindowState(String windowState) {
        return this.validWindowStates.containsKey(windowState);
    }

    protected boolean isValidPortletMode(String portletMode) {
        return this.validPortletModes.containsKey(portletMode);
    }
}

