/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseGetResourceAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.GetThemesAction;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFoldersListAction
extends BaseGetResourceAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetThemesAction.class);

    public GetFoldersListAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getfolderlist");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get folderlist");
                return success;
            }
            String folderName = this.getActionParameter(requestContext, "data");
            if (folderName == null) {
                success = false;
                resultMap.put("reason", "Folder name not found.");
                return success;
            }
            Folder folder = this.pageManager.getFolder(folderName);
            resultMap.put("folders", folder.getFolders().iterator());
            resultMap.put("pages", folder.getPages().iterator());
            resultMap.put("links", folder.getLinks().iterator());
            resultMap.put("status", status);
        }
        catch (Exception e) {
            this.log.error("exception while getting theme info", (Throwable)e);
            success = false;
        }
        return success;
    }
}

