/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseGetResourceAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.common.SecuredResource;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLinkAction
extends BaseGetResourceAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetLinkAction.class);

    public GetLinkAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getlink");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get link");
                return success;
            }
            Link link = this.retrieveLink(requestContext);
            resultMap.put("status", status);
            resultMap.put("link", link);
            this.putSecurityInformation(resultMap, (SecuredResource)link);
        }
        catch (Exception e) {
            this.log.error("exception while getting link info", (Throwable)e);
            resultMap.put("reason", e.getMessage());
            success = false;
        }
        return success;
    }

    protected Link retrieveLink(RequestContext requestContext) throws Exception {
        String linkName = this.getActionParameter(requestContext, "link");
        if (linkName == null) {
            linkName = "/";
        }
        Link link = this.pageManager.getLink(linkName);
        return link;
    }
}

