/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.GetMenusAction;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMenuAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(GetMenusAction.class);

    public GetMenuAction(String template, String errorTemplate, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getmenu");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to get menu");
                return success;
            }
            String menuName = this.getActionParameter(requestContext, "name");
            if (menuName == null) {
                success = false;
                resultMap.put("reason", "Missing required 'name' parameter");
                return success;
            }
            PortalSiteRequestContext siteRequestContext = (PortalSiteRequestContext)requestContext.getAttribute("org.apache.jetspeed.portalsite.PortalSiteRequestContext");
            if (siteRequestContext == null) {
                success = false;
                resultMap.put("reason", "Missing portal site request context from ProfilerValve");
                return success;
            }
            Locale locale = requestContext.getLocale();
            Menu menuDefinition = null;
            try {
                menuDefinition = siteRequestContext.getMenu(menuName);
            }
            catch (NodeNotFoundException nnfe) {
                // empty catch block
            }
            if (menuDefinition == null) {
                success = false;
                resultMap.put("reason", "Unable to lookup specified menu for page");
                return success;
            }
            resultMap.put("menu", menuDefinition);
            resultMap.put("menuContext", siteRequestContext);
            resultMap.put("menuLocale", locale);
            resultMap.put("status", status);
        }
        catch (Exception e) {
            log.error("Exception while getting page menus info", (Throwable)e);
            success = false;
        }
        return success;
    }
}

