/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.decoration.DecorationValve;
import org.apache.jetspeed.decoration.PageActionAccess;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseGetResourceAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.PortletPlacementMetadataAccess;
import org.apache.jetspeed.om.common.SecuredResource;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPageAction
extends BaseGetResourceAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetPageAction.class);
    private PortletRegistry registry;
    private DecorationValve decorationValve;

    public GetPageAction(String template, String errorTemplate, PageManager pageManager, PortletActionSecurityBehavior securityBehavior, PortletRegistry registry, DecorationValve decorationValve) {
        super(template, errorTemplate, pageManager, securityBehavior);
        this.registry = registry;
        this.decorationValve = decorationValve;
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            PortalSiteRequestContext siteRequestContext;
            resultMap.put("action", "getpage");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                resultMap.put("reason", "Insufficient access to view page");
                success = false;
                return success;
            }
            this.decorationValve.invoke(requestContext, null);
            ContentPage page = requestContext.getPage();
            String pageName = this.getActionParameter(requestContext, "page");
            if (page == null) {
                throw new AJAXException("Missing current page or 'page' parameter");
            }
            resultMap.put("status", status);
            resultMap.put("page", page);
            Theme theme = (Theme)requestContext.getAttribute("org.apache.jetspeed.theme");
            String pageDecoratorName = null;
            pageDecoratorName = theme != null ? theme.getPageLayoutDecoration().getName() : page.getDefaultDecorator("layout");
            if (pageDecoratorName != null) {
                resultMap.put("defaultLayout", pageDecoratorName);
            }
            if ((siteRequestContext = (PortalSiteRequestContext)requestContext.getAttribute("org.apache.jetspeed.portalsite.PortalSiteRequestContext")) == null) {
                success = false;
                resultMap.put("reason", "Missing portal site request context from ProfilerValve");
                return success;
            }
            String profiledPath = siteRequestContext.getPageOrTemplate().getPath();
            resultMap.put("profiledPath", profiledPath);
            this.putSecurityInformation(resultMap, (SecuredResource)page.getPageOrTemplate());
            PageActionAccess pageActionAccess = (PageActionAccess)requestContext.getAttribute("org.apache.jetspeed.decoration.PageEditAccess");
            Boolean userIsAnonymous = Boolean.TRUE;
            if (pageActionAccess != null) {
                userIsAnonymous = new Boolean(pageActionAccess.isAnonymous());
            }
            resultMap.put("userIsAnonymous", userIsAnonymous.toString());
            Boolean isPageQualifiedForCreateNewPageOnEdit = Boolean.FALSE;
            if (!userIsAnonymous.booleanValue()) {
                isPageQualifiedForCreateNewPageOnEdit = new Boolean(this.isPageQualifiedForCreateNewPageOnEdit(requestContext));
            }
            resultMap.put("pageQualifiedForCreateNewPageOnEdit", isPageQualifiedForCreateNewPageOnEdit.toString());
            String fragments = this.getActionParameter(requestContext, "fragments");
            if (fragments == null) {
                resultMap.put("fragments", "true");
            } else if (fragments.equalsIgnoreCase("true")) {
                resultMap.put("fragments", "true");
            } else {
                resultMap.put("fragments", "false");
                return success;
            }
            HashMap fragSizes = new HashMap();
            HashMap portletIcons = new HashMap();
            String singleLayoutId = this.getActionParameter(requestContext, "layoutid");
            if (singleLayoutId == null) {
                if (page.getRootFragment() instanceof ContentFragment) {
                    this.retrieveFragmentSpecialProperties(requestContext, page.getRootFragment(), fragSizes, portletIcons);
                } else {
                    throw new Exception("root layout not found for page: " + page.getId());
                }
            }
            resultMap.put("sizes", fragSizes);
            resultMap.put("portletIcons", portletIcons);
        }
        catch (Exception e) {
            this.log.error("exception while getting page", (Throwable)e);
            success = false;
        }
        return success;
    }

    protected Page retrievePage(RequestContext requestContext, String pageName) throws Exception {
        if (pageName == null) {
            pageName = "/";
        }
        Page page = this.pageManager.getPage(pageName);
        return page;
    }

    protected void retrieveFragmentSpecialProperties(RequestContext requestContext, ContentFragment frag, Map fragSizes, Map portletIcons) {
        String portletName;
        if (frag == null) {
            return;
        }
        if ("layout".equals(frag.getType())) {
            List childFragments;
            if (fragSizes != null) {
                PortletPlacementMetadataAccess.getColumnCountAndSizes(frag, this.registry, fragSizes);
            }
            if ((childFragments = frag.getFragments()) != null) {
                for (ContentFragment childFrag : childFragments) {
                    this.retrieveFragmentSpecialProperties(requestContext, childFrag, fragSizes, portletIcons);
                }
            }
        } else if (portletIcons != null && "portlet".equals(frag.getType()) && (portletName = frag.getName()) != null && portletName.length() > 0) {
            PortletDefinition portletDef = this.registry.getPortletDefinitionByUniqueName(portletName, true);
            if (portletDef != null && portletIcons != null) {
                String iconParamVal;
                InitParam iconParam = portletDef.getInitParam("portlet-icon");
                String string = iconParamVal = iconParam == null ? null : iconParam.getParamValue();
                if (iconParamVal != null && iconParamVal.length() > 0) {
                    portletIcons.put(frag.getId(), iconParamVal);
                }
            } else if (portletDef == null) {
                this.log.error("GetPageAction could not obtain PortletDefinition for portlet " + portletName);
            }
        }
    }
}

