/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.decoration.DecorationValve;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPortletActionsAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected static final Logger log = LoggerFactory.getLogger(GetPortletActionsAction.class);
    protected String action;
    private DecorationValve decorationValve;

    public GetPortletActionsAction(String template, String errorTemplate, String action, DecorationValve decorationValve) throws AJAXException {
        this(template, errorTemplate, action, decorationValve, null, null);
    }

    public GetPortletActionsAction(String template, String errorTemplate, String action, DecorationValve decorationValve, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) throws AJAXException {
        super(template, errorTemplate, pageManager, securityBehavior);
        this.action = action;
        this.decorationValve = decorationValve;
    }

    public boolean runBatch(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, true);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        return this.runAction(requestContext, resultMap, false);
    }

    public boolean runAction(RequestContext requestContext, Map resultMap, boolean batch) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", this.action);
            ContentPage page = requestContext.getPage();
            ArrayList<ContentFragment> getActionsForFragments = new ArrayList<ContentFragment>();
            String[] portletIds = requestContext.getRequest().getParameterValues("id");
            if (portletIds != null && portletIds.length > 0) {
                for (int i = 0; i < portletIds.length; ++i) {
                    String portletId = portletIds[i];
                    ContentFragment fragment = page.getFragmentById(portletId);
                    if (fragment == null) {
                        throw new Exception("fragment not found for specified portlet id: " + portletId);
                    }
                    getActionsForFragments.add(fragment);
                }
                getActionsForFragments.add(page.getRootFragment());
            }
            this.decorationValve.initFragments(requestContext, true, getActionsForFragments);
            if (getActionsForFragments.size() > 0) {
                Fragment rootFragment = (Fragment)getActionsForFragments.remove(getActionsForFragments.size() - 1);
                resultMap.put("page", rootFragment);
            }
            resultMap.put("portlets", getActionsForFragments);
            resultMap.put("status", status);
        }
        catch (Exception e) {
            log.error("exception while getting actions for a fragment", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }
}

