/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BasePortletAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.PortletInfo;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.SecurityAccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPortletsAction
extends BasePortletAction
implements AjaxAction,
AjaxBuilder,
Constants,
Comparator {
    protected static final Logger log = LoggerFactory.getLogger(GetPortletsAction.class);
    private PortletRegistry registry = null;
    private SearchEngine searchEngine = null;
    private SecurityAccessController securityAccessController;
    public static final String PORTLET_ICON = "portlet-icon";

    public GetPortletsAction(String template, String errorTemplate) {
        this(template, errorTemplate, null, null, null, null, null);
    }

    public GetPortletsAction(String template, String errorTemplate, PageManager pageManager, PortletRegistry registry, SearchEngine searchEngine, SecurityAccessController securityAccessController, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pageManager, securityBehavior);
        this.registry = registry;
        this.searchEngine = searchEngine;
        this.securityAccessController = securityAccessController;
    }

    public boolean run(RequestContext requestContext, Map resultMap) {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "getportlets");
            if (!this.checkAccess(requestContext, JetspeedActions.VIEW)) {
                success = false;
                resultMap.put("reason", "Insufficient access to edit page");
                return success;
            }
            String type = this.getActionParameter(requestContext, "type");
            String format = this.getActionParameter(requestContext, "format");
            String filter = this.getActionParameter(requestContext, "filter");
            List portlets = this.retrievePortlets(requestContext, filter);
            resultMap.put("type", type);
            resultMap.put("format", format);
            resultMap.put("status", status);
            resultMap.put("portlets", portlets);
        }
        catch (Exception e) {
            log.error("exception while getting portlet info", (Throwable)e);
            success = false;
        }
        return success;
    }

    public List retrievePortlets(RequestContext requestContext, String filter) {
        Iterator portlets = null;
        ArrayList<PortletInfo> list = new ArrayList<PortletInfo>();
        Locale locale = requestContext.getLocale();
        portlets = filter == null ? this.registry.getAllPortletDefinitions().iterator() : this.searchEngine.search(filter).getResults().iterator();
        while (portlets.hasNext()) {
            PortletApplication pa;
            PortletDefinition portlet = null;
            portlet = filter == null ? (PortletDefinition)portlets.next() : this.getPortletFromParsedObject((ParsedObject)portlets.next());
            if (portlet == null || (pa = portlet.getApplication()).isLayoutApplication()) continue;
            String uniqueName = pa.getName() + "::" + portlet.getPortletName();
            if (!this.securityAccessController.checkPortletAccess(portlet, 8)) continue;
            InitParam param = portlet.getInitParam(PORTLET_ICON);
            String image = param != null ? "images/portlets/" + param.getParamValue() : "images/portlets/applications-internet.png";
            PortletInfo portInfo = new PortletInfo(uniqueName, StringEscapeUtils.escapeXml((String)portlet.getDisplayNameText(locale)), StringEscapeUtils.escapeXml((String)portlet.getDescriptionText(locale)), image);
            list.add(portInfo);
        }
        Collections.sort(list, this);
        return list;
    }

    protected PortletDefinition getPortletFromParsedObject(ParsedObject po) {
        boolean found = false;
        String name = "";
        Map fields = po.getFields();
        if (fields != null) {
            Object id = fields.get("ID");
            if (id != null) {
                if (id instanceof Collection) {
                    Collection coll = (Collection)id;
                    name = (String)coll.iterator().next();
                } else {
                    name = (String)id;
                }
            }
            if (po.getType().equals("portlet")) {
                Object pa = fields.get("portlet_application");
                String paName = "";
                if (pa != null) {
                    if (id instanceof Collection) {
                        Collection coll = (Collection)pa;
                        paName = (String)coll.iterator().next();
                    } else {
                        paName = (String)pa;
                    }
                }
                name = paName + "::" + name;
                found = true;
            }
        }
        if (!found) {
            return null;
        }
        return this.registry.getPortletDefinitionByUniqueName(name, true);
    }

    public int compare(Object obj1, Object obj2) {
        PortletInfo portlet1 = (PortletInfo)obj1;
        PortletInfo portlet2 = (PortletInfo)obj2;
        String name1 = portlet1.getName();
        String name2 = portlet2.getName();
        name1 = name1 == null ? "unknown" : name1;
        name2 = name2 == null ? "unknown" : name2;
        return name1.compareTo(name2);
    }
}

