/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.impl.BaseUserAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.RolesSecurityBehavior;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserInformationAction
extends BaseUserAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetUserInformationAction.class);

    public GetUserInformationAction(String template, String errorTemplate, UserManager um, RolesSecurityBehavior rolesSecurityBehavior) {
        super(template, errorTemplate, um, rolesSecurityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "userinformation");
            if (!requestContext.getUserPrincipal().getName().equals(this.userManager.getAnonymousUser())) {
                Principal principal = requestContext.getUserPrincipal();
                resultMap.put("username", principal.getName());
                resultMap.put("type", principal.getClass().getName());
                User user = this.userManager.getUser(principal.getName());
                if (user != null) {
                    Map userInfo = user.getInfoMap();
                    resultMap.put("userinfo", userInfo);
                    ArrayList<String> roles = new ArrayList<String>();
                    Subject userSubject = this.userManager.getSubject(user);
                    if (userSubject != null) {
                        for (Role role : userSubject.getPrincipals(Role.class)) {
                            roles.add(role.getName());
                        }
                    }
                    resultMap.put("roles", roles);
                }
            } else {
                status = "failure";
                resultMap.put("reason", "Not logged in");
                return false;
            }
            resultMap.put("status", status);
        }
        catch (Exception e) {
            this.log.error("exception with user account access", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }
}

