/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.container.session.PortalSessionsManager;
import org.apache.jetspeed.layout.impl.BaseUserAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.layout.impl.RolesSecurityBehavior;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.apache.jetspeed.statistics.UserStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetUserListAction
extends BaseUserAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(GetUserListAction.class);
    private PortalStatistics pstats = null;
    private PortalSessionsManager psm = null;
    private String protectionScope = "all";
    private final String PARAM_GUEST = "guest";
    private final String PARAM_USERINFO = "userinfo";
    private final String PARAM_OFFILE = "offline";
    private final String PARAM_ALL = "all";

    public GetUserListAction(String template, String errorTemplate, UserManager um, PortalStatistics pstats, PortalSessionsManager psm) {
        this(template, errorTemplate, um, pstats, psm, null);
    }

    public GetUserListAction(String template, String errorTemplate, UserManager um, PortalStatistics pstats, PortalSessionsManager psm, RolesSecurityBehavior securityBehavior) {
        super(template, errorTemplate, um, securityBehavior);
        this.pstats = pstats;
        this.psm = psm;
    }

    public GetUserListAction(String template, String errorTemplate, UserManager um, PortalStatistics pstats, PortalSessionsManager psm, RolesSecurityBehavior securityBehavior, String protectionScope) {
        super(template, errorTemplate, um, securityBehavior);
        this.pstats = pstats;
        this.psm = psm;
        this.protectionScope = protectionScope;
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean includeOffline;
        boolean includeUserInfo;
        boolean includeGuests;
        boolean success = true;
        String status = "success";
        boolean includeAll = this.isTrue(this.getActionParameter(requestContext, "all"));
        if (includeAll) {
            includeGuests = true;
            includeUserInfo = true;
            includeOffline = true;
        } else {
            includeOffline = this.isTrue(this.getActionParameter(requestContext, "offline"));
            includeGuests = this.isTrue(this.getActionParameter(requestContext, "guest"));
            includeUserInfo = this.isTrue(this.getActionParameter(requestContext, "userinfo"));
        }
        if (this.securityBehavior != null && !this.checkAccess(requestContext, JetspeedActions.EDIT) && !this.protectionScope.equals("none")) {
            if (this.protectionScope.equals("private-offline")) {
                includeUserInfo = false;
                includeOffline = false;
            } else if (this.protectionScope.equals("private")) {
                includeUserInfo = false;
            } else {
                success = false;
                resultMap.put("reason", "Insufficient access see user details.");
                return success;
            }
        }
        int numberOfCurrentUsers = 0;
        int numberOfCurrentLoggedInUsers = 0;
        ArrayList users = new ArrayList();
        ArrayList loggedInUsers = new ArrayList();
        ArrayList offlineUsers = new ArrayList();
        try {
            resultMap.put("action", "getuserlist");
            if (this.pstats != null) {
                numberOfCurrentUsers = this.psm.sessionCount();
                numberOfCurrentLoggedInUsers = this.pstats.getNumberOfLoggedInUsers();
                ArrayList<String> addedUserNames = new ArrayList<String>();
                if (numberOfCurrentLoggedInUsers > 0) {
                    for (Map userMap : this.pstats.getListOfLoggedInUsers()) {
                        if (userMap == null || userMap.size() <= 0) continue;
                        Iterator userKeyIter = userMap.keySet().iterator();
                        while (userKeyIter.hasNext()) {
                            String userStatKey = String.valueOf(userKeyIter.next());
                            UserStats userStat = (UserStats)userMap.get(userStatKey);
                            HashMap<String, Object> singleUserMap = new HashMap<String, Object>();
                            singleUserMap.put("username", userStat.getUsername());
                            singleUserMap.put("sessions", new Integer(userStat.getNumberOfSessions()));
                            singleUserMap.put("status", "online");
                            singleUserMap.put("ipaddress", userStat.getInetAddress().getHostAddress());
                            if (includeUserInfo) {
                                singleUserMap.put("userinfo", this.getUserInfo(userStat.getUsername()));
                            }
                            if (!addedUserNames.contains(userStat.getUsername())) {
                                addedUserNames.add(userStat.getUsername());
                            }
                            loggedInUsers.add(singleUserMap);
                        }
                    }
                    users.addAll(loggedInUsers);
                }
                if (includeOffline) {
                    for (User user : this.userManager.getUsers("")) {
                        Principal userPrincipal = SubjectHelper.getPrincipal((Subject)this.userManager.getSubject(user), User.class);
                        if (userPrincipal == null || addedUserNames.contains(userPrincipal.getName())) continue;
                        HashMap<String, Object> userMap = new HashMap<String, Object>();
                        userMap.put("username", userPrincipal.getName());
                        userMap.put("status", "offline");
                        if (includeUserInfo) {
                            userMap.put("userinfo", this.getUserInfo(userPrincipal.getName()));
                        }
                        offlineUsers.add(userMap);
                    }
                    users.addAll(offlineUsers);
                }
                resultMap.put("users", users);
                if (includeGuests) {
                    int guestUserCount = numberOfCurrentUsers - numberOfCurrentLoggedInUsers;
                    resultMap.put("guestusers", new Integer(guestUserCount));
                }
            } else {
                status = "failure";
                resultMap.put("reason", "Statistics not available");
                return false;
            }
            resultMap.put("status", status);
        }
        catch (Exception e) {
            this.log.error("exception statistics access", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    private Map<String, String> getUserInfo(String username) throws SecurityException {
        User user = this.userManager.getUser(username);
        if (user != null) {
            return user.getInfoMap();
        }
        return new HashMap<String, String>();
    }
}

