/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.valve.Valve;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletActionSecurityPathBehavior
implements PortletActionSecurityBehavior {
    protected Logger log = LoggerFactory.getLogger(PortletActionSecurityPathBehavior.class);
    protected PageManager pageManager;
    protected Valve pageLocatingValve;
    private boolean enableCreateUserPagesFromRolesOnEdit;

    public PortletActionSecurityPathBehavior(PageManager pageManager, Valve pageLocatingValve) {
        this(pageManager, pageLocatingValve, Boolean.FALSE);
    }

    public PortletActionSecurityPathBehavior(PageManager pageManager, Valve pageLocatingValve, Boolean enableCreateUserPagesFromRolesOnEdit) {
        this.pageManager = pageManager;
        this.pageLocatingValve = pageLocatingValve;
        this.enableCreateUserPagesFromRolesOnEdit = enableCreateUserPagesFromRolesOnEdit == null ? false : enableCreateUserPagesFromRolesOnEdit;
    }

    public boolean checkAccess(RequestContext context, String action) {
        ContentPage page = context.getPage();
        String path = page.getPath();
        if (path == null) {
            return false;
        }
        if (path.indexOf("/_role/") > -1 || path.indexOf("/_group/") > -1) {
            return action.equals(JetspeedActions.VIEW);
        }
        return true;
    }

    public boolean isCreateNewPageOnEditEnabled() {
        return this.enableCreateUserPagesFromRolesOnEdit;
    }

    public boolean isPageQualifiedForCreateNewPageOnEdit(RequestContext context) {
        if (!this.enableCreateUserPagesFromRolesOnEdit || context == null) {
            return false;
        }
        return this.isPageQualifiedForCreateNewPageOnEdit(context.getPage().getPath());
    }

    protected boolean isPageQualifiedForCreateNewPageOnEdit(String pagePath) {
        if (pagePath == null) {
            return false;
        }
        return pagePath.indexOf("/_role/") == 0;
    }

    public boolean createNewPageOnEdit(RequestContext context) {
        if (!this.enableCreateUserPagesFromRolesOnEdit) {
            return false;
        }
        ContentPage contentPage = context.getPage();
        String pagePath = contentPage.getPath();
        try {
            if (this.isPageQualifiedForCreateNewPageOnEdit(pagePath)) {
                String pageName = contentPage.getName();
                this.pageManager.createUserHomePagesFromRoles(context.getSubject());
                this.pageLocatingValve.invoke(context, null);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

