/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseSiteUpdateAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateFolderAction
extends BaseSiteUpdateAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(UpdateFolderAction.class);

    public UpdateFolderAction(String template, String errorTemplate, PageManager pm, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pm, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "updatefolder");
            String method = this.getActionParameter(requestContext, "method");
            if (method == null) {
                throw new RuntimeException("Method not provided");
            }
            resultMap.put("method", method);
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                success = false;
                resultMap.put("reason", "Insufficient access to administer portal permissions");
                return success;
            }
            int count = 0;
            String path = this.getActionParameter(requestContext, "path");
            if (path == null) {
                throw new AJAXException("Missing 'path' parameter");
            }
            Folder folder = null;
            if (!method.equals("add")) {
                folder = this.pageManager.getFolder(path);
            } else if (this.pageManager.folderExists(path)) {
                success = false;
                resultMap.put("reason", "Can't create: Folder already exists: " + path);
                return success;
            }
            if (method.equals("info")) {
                count = this.updateInformation(requestContext, resultMap, (Node)folder, path);
            } else if (method.equals("add-meta")) {
                count = this.insertMetadata(requestContext, resultMap, (Node)folder);
            } else if (method.equals("update-meta")) {
                count = this.updateMetadata(requestContext, resultMap, (Node)folder);
            } else if (method.equals("remove-meta")) {
                count = this.removeMetadata(requestContext, resultMap, (Node)folder);
            } else if (method.equals("update-secref")) {
                count = this.updateSecurityReference(requestContext, resultMap, (Node)folder);
            } else if (method.equals("add-secref")) {
                count = this.insertSecurityReference(requestContext, resultMap, (Node)folder);
            } else if (method.equals("remove-secref")) {
                count = this.removeSecurityReference(requestContext, resultMap, (Node)folder);
            } else if (method.equals("remove-secdef")) {
                count = this.removeSecurityDef(requestContext, resultMap, (Node)folder);
            } else if (method.equals("add")) {
                folder = this.pageManager.newFolder(path);
                folder.setTitle(this.getActionParameter(requestContext, "title"));
                String s = this.getActionParameter(requestContext, "short-title");
                if (!this.isBlank(s)) {
                    folder.setShortTitle(s);
                }
                ++count;
            } else if (method.equals("copy")) {
                String destination = this.getActionParameter(requestContext, "destination");
                String name = this.getActionParameter(requestContext, "name");
                destination = destination + "/" + name;
                this.pageManager.deepCopyFolder(folder, destination, null);
            } else if (method.equals("move")) {
                String destination = this.getActionParameter(requestContext, "destination");
                String name = this.getActionParameter(requestContext, "name");
                destination = destination + "/" + name;
                this.pageManager.deepCopyFolder(folder, destination, null, true);
                this.pageManager.removeFolder(folder);
            } else if (method.equals("remove")) {
                this.pageManager.removeFolder(folder);
            } else {
                success = false;
                resultMap.put("reason", "Unsupported Site Update method: " + method);
                return success;
            }
            if (count > 0) {
                this.pageManager.updateFolder(folder);
            }
            resultMap.put("count", Integer.toString(count));
            resultMap.put("status", status);
        }
        catch (Exception e) {
            this.log.error("exception administering Site update", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected int updateInformation(RequestContext requestContext, Map resultMap, Node node, String path) throws AJAXException {
        int count = 0;
        try {
            String hidden;
            String defaultPage;
            String portletDecorator;
            String layoutDecorator;
            String shortTitle;
            Folder folder = (Folder)node;
            String title = this.getActionParameter(requestContext, "title");
            if (this.isFieldModified(title, folder.getTitle())) {
                folder.setTitle(title);
            }
            if (this.isFieldModified(shortTitle = this.getActionParameter(requestContext, "short-title"), folder.getShortTitle())) {
                folder.setShortTitle(shortTitle);
            }
            if (this.isFieldModified(layoutDecorator = this.getActionParameter(requestContext, "layout-decorator"), folder.getDefaultDecorator("layout"))) {
                if (this.isBlank(layoutDecorator)) {
                    layoutDecorator = null;
                }
                folder.setDefaultDecorator(layoutDecorator, "layout");
            }
            if (this.isFieldModified(portletDecorator = this.getActionParameter(requestContext, "portlet-decorator"), folder.getDefaultDecorator("portlet"))) {
                if (this.isBlank(portletDecorator)) {
                    portletDecorator = null;
                }
                folder.setDefaultDecorator(portletDecorator, "portlet");
            }
            if (this.isFieldModified(defaultPage = this.getActionParameter(requestContext, "default-page"), folder.getDefaultPage())) {
                folder.setDefaultPage(defaultPage);
            }
            if (this.isBooleanModified(hidden = this.getActionParameter(requestContext, "hidden"), folder.isHidden())) {
                folder.setHidden(!folder.isHidden());
            }
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return ++count;
    }
}

