/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseSiteUpdateAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLinkAction
extends BaseSiteUpdateAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(UpdateLinkAction.class);

    public UpdateLinkAction(String template, String errorTemplate, PageManager pm, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pm, securityBehavior);
    }

    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            resultMap.put("action", "updatelink");
            String method = this.getActionParameter(requestContext, "method");
            if (method == null) {
                throw new RuntimeException("Method not provided");
            }
            resultMap.put("method", method);
            if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                success = false;
                resultMap.put("reason", "Insufficient access to administer portal permissions");
                return success;
            }
            int count = 0;
            String path = this.getActionParameter(requestContext, "path");
            if (path == null) {
                throw new AJAXException("Missing 'path' parameter");
            }
            Link link = null;
            if (!method.equals("add")) {
                link = this.pageManager.getLink(path);
            } else if (this.pageManager.linkExists(path)) {
                success = false;
                resultMap.put("reason", "Can't create: Link already exists: " + path);
                return success;
            }
            if (method.equals("info")) {
                count = this.updateInformation(requestContext, resultMap, (Node)link, path);
            } else if (method.equals("update-meta")) {
                count = this.updateMetadata(requestContext, resultMap, (Node)link);
            } else if (method.equals("add-meta")) {
                count = this.insertMetadata(requestContext, resultMap, (Node)link);
            } else if (method.equals("remove-meta")) {
                count = this.removeMetadata(requestContext, resultMap, (Node)link);
            } else if (method.equals("add-secref")) {
                count = this.insertSecurityReference(requestContext, resultMap, (Node)link);
            } else if (method.equals("update-secref")) {
                count = this.updateSecurityReference(requestContext, resultMap, (Node)link);
            } else if (method.equals("remove-secref")) {
                count = this.removeSecurityReference(requestContext, resultMap, (Node)link);
            } else if (method.equals("remove-secdef")) {
                count = this.removeSecurityDef(requestContext, resultMap, (Node)link);
            } else if (method.equals("add")) {
                link = this.pageManager.newLink(path);
                link.setTitle(this.getActionParameter(requestContext, "title"));
                String s = this.getActionParameter(requestContext, "short-title");
                if (!this.isBlank(s)) {
                    link.setShortTitle(s);
                }
                link.setUrl(this.getActionParameter(requestContext, "url"));
                ++count;
            } else if (method.equals("copy")) {
                String destination = this.getActionParameter(requestContext, "destination");
                String name = this.getActionParameter(requestContext, "name");
                destination = destination + "/" + name;
                Link newLink = this.pageManager.copyLink(link, destination);
                this.pageManager.updateLink(newLink);
            } else if (method.equals("move")) {
                String destination = this.getActionParameter(requestContext, "destination");
                String name = this.getActionParameter(requestContext, "name");
                destination = destination + "/" + name;
                Link newLink = this.pageManager.copyLink(link, destination);
                this.pageManager.updateLink(newLink);
                this.pageManager.removeLink(link);
            } else if (method.equals("remove")) {
                this.pageManager.removeLink(link);
            } else {
                success = false;
                resultMap.put("reason", "Unsupported Site Update method: " + method);
                return success;
            }
            if (count > 0) {
                this.pageManager.updateLink(link);
            }
            resultMap.put("count", Integer.toString(count));
            resultMap.put("status", status);
        }
        catch (Exception e) {
            this.log.error("exception administering Site update", (Throwable)e);
            resultMap.put("reason", e.toString());
            success = false;
        }
        return success;
    }

    protected int updateInformation(RequestContext requestContext, Map resultMap, Node node, String path) throws AJAXException {
        int count = 0;
        try {
            String hidden;
            String target;
            String url;
            String shortTitle;
            Link link = (Link)node;
            String title = this.getActionParameter(requestContext, "title");
            if (this.isFieldModified(title, link.getTitle())) {
                link.setTitle(title);
            }
            if (this.isFieldModified(shortTitle = this.getActionParameter(requestContext, "short-title"), link.getShortTitle())) {
                link.setShortTitle(shortTitle);
            }
            if (this.isFieldModified(url = this.getActionParameter(requestContext, "url"), link.getUrl())) {
                link.setUrl(url);
            }
            if (this.isFieldModified(target = this.getActionParameter(requestContext, "target"), link.getTarget())) {
                link.setTarget(target);
            }
            if (this.isBooleanModified(hidden = this.getActionParameter(requestContext, "hidden"), link.isHidden())) {
                link.setHidden(!link.isHidden());
            }
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return ++count;
    }
}

