/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.ajax.AJAXException;
import org.apache.jetspeed.ajax.AjaxAction;
import org.apache.jetspeed.ajax.AjaxBuilder;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.impl.BaseSiteUpdateAction;
import org.apache.jetspeed.layout.impl.Constants;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePageAction
extends BaseSiteUpdateAction
implements AjaxAction,
AjaxBuilder,
Constants {
    protected Logger log = LoggerFactory.getLogger(UpdatePageAction.class);

    public UpdatePageAction(String template, String errorTemplate, PageManager pm, PortletActionSecurityBehavior securityBehavior) {
        super(template, errorTemplate, pm, securityBehavior);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(RequestContext requestContext, Map resultMap) throws AJAXException {
        boolean success = true;
        String status = "success";
        try {
            BaseFragmentsElement page;
            int count;
            block40: {
                String method;
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                String l;
                                String path;
                                block47: {
                                    block46: {
                                        block45: {
                                            block44: {
                                                block43: {
                                                    block42: {
                                                        block41: {
                                                            block39: {
                                                                resultMap.put("action", "updatepage");
                                                                method = this.getActionParameter(requestContext, "method");
                                                                if (method == null) {
                                                                    throw new RuntimeException("Method not provided");
                                                                }
                                                                resultMap.put("method", method);
                                                                if (!this.checkAccess(requestContext, JetspeedActions.EDIT)) {
                                                                    success = false;
                                                                    resultMap.put("reason", "Insufficient access to administer portal permissions");
                                                                    return success;
                                                                }
                                                                count = 0;
                                                                page = null;
                                                                path = this.getActionParameter(requestContext, "path");
                                                                if (path == null) {
                                                                    page = requestContext.getPage().getPageOrTemplate();
                                                                } else if (!method.equals("add")) {
                                                                    if (path.endsWith(".psml")) {
                                                                        page = this.pageManager.getPage(path);
                                                                    } else {
                                                                        if (!path.endsWith(".dpsml")) {
                                                                            success = false;
                                                                            resultMap.put("reason", "Can't lookup page by document type: " + path);
                                                                            return success;
                                                                        }
                                                                        page = this.pageManager.getDynamicPage(path);
                                                                    }
                                                                } else if (this.pageManager.pageExists(path) || this.pageManager.dynamicPageExists(path)) {
                                                                    success = false;
                                                                    resultMap.put("reason", "Can't create: Page already exists: " + path);
                                                                    return success;
                                                                }
                                                                if (page == null) {
                                                                    throw new AJAXException("Missing current page or 'path' parameter");
                                                                }
                                                                if (!method.equals("info")) break block39;
                                                                count = this.updateInformation(requestContext, resultMap, (Node)page, path);
                                                                break block40;
                                                            }
                                                            if (!method.equals("add-meta")) break block41;
                                                            count = this.insertMetadata(requestContext, resultMap, (Node)page);
                                                            break block40;
                                                        }
                                                        if (!method.equals("update-meta")) break block42;
                                                        count = this.updateMetadata(requestContext, resultMap, (Node)page);
                                                        break block40;
                                                    }
                                                    if (!method.equals("remove-meta")) break block43;
                                                    count = this.removeMetadata(requestContext, resultMap, (Node)page);
                                                    break block40;
                                                }
                                                if (!method.equals("add-secref")) break block44;
                                                count = this.insertSecurityReference(requestContext, resultMap, (Node)page);
                                                break block40;
                                            }
                                            if (!method.equals("update-secref")) break block45;
                                            count = this.updateSecurityReference(requestContext, resultMap, (Node)page);
                                            break block40;
                                        }
                                        if (!method.equals("remove-secref")) break block46;
                                        count = this.removeSecurityReference(requestContext, resultMap, (Node)page);
                                        break block40;
                                    }
                                    if (!method.equals("remove-secdef")) break block47;
                                    count = this.removeSecurityDef(requestContext, resultMap, (Node)page);
                                    break block40;
                                }
                                if (!method.equals("add")) break block48;
                                page = this.pageManager.newPage(path);
                                page.setTitle(this.getActionParameter(requestContext, "title"));
                                String s = this.getActionParameter(requestContext, "short-title");
                                if (!this.isBlank(s)) {
                                    page.setShortTitle(s);
                                }
                                if (!this.isBlank(l = this.getActionParameter(requestContext, "defaultLayout")) && page.getRootFragment() instanceof Fragment) {
                                    Fragment rootFragment = (Fragment)page.getRootFragment();
                                    rootFragment.setName(this.getActionParameter(requestContext, "defaultLayout"));
                                }
                                ++count;
                                break block40;
                            }
                            if (!method.equals("copy")) break block49;
                            String destination = this.getActionParameter(requestContext, "destination");
                            String name = this.getActionParameter(requestContext, "name");
                            destination = destination + "/" + name;
                            if (page instanceof Page) {
                                Page newPage = this.pageManager.copyPage((Page)page, destination);
                                this.pageManager.updatePage(newPage);
                                break block40;
                            } else if (page instanceof DynamicPage) {
                                DynamicPage newPage = this.pageManager.copyDynamicPage((DynamicPage)page, destination);
                                this.pageManager.updateDynamicPage(newPage);
                            }
                            break block40;
                        }
                        if (!method.equals("move")) break block50;
                        String destination = this.getActionParameter(requestContext, "destination");
                        String name = this.getActionParameter(requestContext, "name");
                        destination = destination + "/" + name;
                        if (page instanceof Page) {
                            Page newPage = this.pageManager.copyPage((Page)page, destination, true);
                            this.pageManager.updatePage(newPage);
                            this.pageManager.removePage((Page)page);
                            break block40;
                        } else if (page instanceof DynamicPage) {
                            DynamicPage newPage = this.pageManager.copyDynamicPage((DynamicPage)page, destination, true);
                            this.pageManager.updateDynamicPage(newPage);
                            this.pageManager.removeDynamicPage((DynamicPage)page);
                        }
                        break block40;
                    }
                    if (!method.equals("remove")) break block51;
                    if (page instanceof Page) {
                        this.pageManager.removePage((Page)page);
                        break block40;
                    } else if (page instanceof DynamicPage) {
                        this.pageManager.removeDynamicPage((DynamicPage)page);
                    }
                    break block40;
                }
                if (method.equals("update-fragment")) {
                    String fragmentId = this.getActionParameter(requestContext, "id");
                    String layout = this.getActionParameter(requestContext, "layout");
                    if (this.isBlank(fragmentId) || this.isBlank(layout)) {
                        resultMap.put("reason", "Missing parameter to update fragment");
                        return false;
                    }
                    count = this.updateFragment(requestContext, resultMap, page, fragmentId, layout);
                } else if (method.equals("add-fragment")) {
                    String parentId = this.getActionParameter(requestContext, "layoutid");
                    String layout = this.getActionParameter(requestContext, "layout");
                    if (this.isBlank(parentId) || this.isBlank(layout)) {
                        resultMap.put("reason", "Missing parameter to add fragment");
                        return false;
                    }
                    count = this.addFragment(requestContext, resultMap, page, parentId, layout);
                } else if (method.equals("remove-fragment")) {
                    String fragmentId = this.getActionParameter(requestContext, "id");
                    if (this.isBlank(fragmentId)) {
                        resultMap.put("reason", "Missing parameter to remove fragment");
                        return false;
                    }
                    count = this.removeFragment(requestContext, resultMap, page, fragmentId);
                } else {
                    if (!method.equals("update-portlet-decorator")) {
                        success = false;
                        resultMap.put("reason", "Unsupported Site Update method: " + method);
                        return success;
                    }
                    String fragmentId = this.getActionParameter(requestContext, "id");
                    String portletDecorator = this.getActionParameter(requestContext, "portlet-decorator");
                    if (this.isBlank(fragmentId) || this.isBlank(portletDecorator)) {
                        resultMap.put("reason", "Missing parameter to update portlet decorator");
                        return false;
                    }
                    count = this.updatePortletDecorator(requestContext, resultMap, page, fragmentId, portletDecorator);
                }
            }
            if (count > 0) {
                if (page instanceof Page) {
                    this.pageManager.updatePage((Page)page);
                } else {
                    this.pageManager.updateDynamicPage((DynamicPage)page);
                }
            }
            resultMap.put("count", Integer.toString(count));
            resultMap.put("status", status);
            return success;
        }
        catch (Exception e) {
            this.log.error("exception administering Site update", (Throwable)e);
            resultMap.put("reason", e.toString());
            return false;
        }
    }

    protected int updatePortletDecorator(RequestContext requestContext, Map resultMap, BaseFragmentsElement page, String fragmentId, String portletDecorator) {
        int count = 0;
        BaseFragmentElement fragment = page.getFragmentById(fragmentId);
        if (fragment != null) {
            fragment.setDecorator(portletDecorator);
            ++count;
        }
        return count;
    }

    protected int updateFragment(RequestContext requestContext, Map resultMap, BaseFragmentsElement page, String fragmentId, String layout) {
        int count = 0;
        String sizes = this.getActionParameter(requestContext, "sizes");
        BaseFragmentElement updateFragment = page.getFragmentById(fragmentId);
        if (updateFragment instanceof Fragment) {
            Fragment fragment = (Fragment)updateFragment;
            if (!layout.equals(fragment.getName())) {
                fragment.setName(layout);
                ++count;
                if (this.isBlank(sizes)) {
                    fragment.setLayoutSizes(null);
                } else {
                    fragment.setLayoutSizes(sizes);
                }
                ++count;
            } else if (!this.isBlank(sizes)) {
                fragment.setLayoutSizes(sizes);
                ++count;
            }
        }
        return count;
    }

    protected int addFragment(RequestContext requestContext, Map resultMap, BaseFragmentsElement page, String parentFragmentId, String layout) {
        int count = 0;
        String sizes = this.getActionParameter(requestContext, "sizes");
        BaseFragmentElement parentFragment = page.getFragmentById(parentFragmentId);
        if (parentFragment instanceof Fragment) {
            Fragment fragment = (Fragment)parentFragment;
            Fragment newFragment = this.pageManager.newFragment();
            newFragment.setType("layout");
            newFragment.setName(layout);
            fragment.getFragments().add(newFragment);
            resultMap.put("id", newFragment.getId());
            ++count;
            if (!this.isBlank(sizes)) {
                newFragment.setLayoutSizes(sizes);
                ++count;
            }
        }
        return count;
    }

    protected int removeFragment(RequestContext requestContext, Map resultMap, BaseFragmentsElement page, String fragmentId) {
        int count = 0;
        BaseFragmentElement fragment = page.getFragmentById(fragmentId);
        if (fragment != null) {
            page.removeFragmentById(fragment.getId());
            ++count;
        }
        return count;
    }

    protected int updateInformation(RequestContext requestContext, Map resultMap, Node node, String path) throws AJAXException {
        int count = 0;
        try {
            String hidden;
            String theme;
            String portletDecorator;
            String layoutDecorator;
            String shortTitle;
            Page page = (Page)node;
            String title = this.getActionParameter(requestContext, "title");
            if (title != null && this.isFieldModified(title, page.getTitle())) {
                page.setTitle(title);
            }
            if ((shortTitle = this.getActionParameter(requestContext, "short-title")) != null && this.isFieldModified(shortTitle, page.getShortTitle())) {
                page.setShortTitle(shortTitle);
            }
            if ((layoutDecorator = this.getActionParameter(requestContext, "layout-decorator")) != null && this.isFieldModified(layoutDecorator, page.getDefaultDecorator("layout"))) {
                if (this.isBlank(layoutDecorator)) {
                    layoutDecorator = null;
                }
                page.setDefaultDecorator(layoutDecorator, "layout");
            }
            if ((portletDecorator = this.getActionParameter(requestContext, "portlet-decorator")) != null && this.isFieldModified(portletDecorator, page.getDefaultDecorator("portlet"))) {
                if (this.isBlank(portletDecorator)) {
                    portletDecorator = null;
                }
                page.setDefaultDecorator(portletDecorator, "portlet");
            }
            if ((theme = this.getActionParameter(requestContext, "theme")) != null && this.isFieldModified(theme, page.getSkin())) {
                if (this.isBlank(theme)) {
                    theme = null;
                }
                page.setSkin(theme);
            }
            if ((hidden = this.getActionParameter(requestContext, "hidden")) != null && this.isBooleanModified(hidden, page.isHidden())) {
                page.setHidden(!page.isHidden());
            }
        }
        catch (Exception e) {
            throw new AJAXException((Throwable)e);
        }
        return ++count;
    }
}

