/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugValveImpl
extends AbstractValve {
    private static final Logger log = LoggerFactory.getLogger(DebugValveImpl.class);

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        this.debugHeaders(request.getRequest());
        context.invokeNext(request);
    }

    public String toString() {
        return "DebugValveImpl";
    }

    private void debugHeaders(HttpServletRequest req) {
        log.info("-- Jetspeed Debug Valve: Debugging standard headers --");
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            log.info("http header = " + name + " : " + value);
        }
    }
}

