/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.Valve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class PropertyLoaderValve
implements Valve {
    protected String m_sKey = null;
    protected PropertiesConfiguration m_oPropertiesConfiguration = null;
    protected String m_sPropertyFilePath = null;

    public PropertyLoaderValve(String p_sKey, PropertiesConfiguration p_oPropertiesConfiguration) {
        this.m_sKey = p_sKey;
        this.m_oPropertiesConfiguration = p_oPropertiesConfiguration;
    }

    public PropertyLoaderValve(String p_sKey, String p_sPropertyFilePath) {
        this.m_sKey = p_sKey;
        this.m_sPropertyFilePath = p_sPropertyFilePath;
    }

    public PropertyLoaderValve(String p_sEnvironmentKey) {
        this.m_sKey = p_sEnvironmentKey;
    }

    public void initialize() throws PipelineException {
        if (this.m_sPropertyFilePath == null && this.m_oPropertiesConfiguration == null) {
            this.m_sPropertyFilePath = System.getProperty(this.m_sKey);
        }
        if (this.m_sPropertyFilePath != null && this.m_oPropertiesConfiguration == null) {
            try {
                this.m_oPropertiesConfiguration = new PropertiesConfiguration(this.m_sPropertyFilePath);
            }
            catch (ConfigurationException e) {
                throw new PipelineException((Throwable)e);
            }
        }
        if (this.m_oPropertiesConfiguration == null) {
            this.m_oPropertiesConfiguration = new PropertiesConfiguration();
        }
    }

    public void invoke(RequestContext p_oRequest, ValveContext p_oContext) throws PipelineException {
        p_oRequest.getRequest().setAttribute(this.m_sKey, (Object)this.m_oPropertiesConfiguration);
        if (p_oContext != null) {
            p_oContext.invokeNext(p_oRequest);
        }
    }
}

