/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class ServletDelegatingValve
extends AbstractValve {
    protected HttpServlet servlet;
    protected ServletConfig config;
    protected boolean servletInitialized;

    public ServletDelegatingValve(HttpServlet servlet, ServletConfig config) {
        this.servlet = servlet;
        this.config = config;
    }

    public void initialize() throws PipelineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.servlet != null && this.servletInitialized) {
            try {
                this.servlet.destroy();
                Object var2_1 = null;
                this.servletInitialized = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.servletInitialized = false;
                throw throwable;
            }
        }
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            if (!this.servletInitialized) {
                this.initServlet();
            }
            this.servlet.service((ServletRequest)request.getRequest(), (ServletResponse)request.getResponse());
        }
        catch (Exception e) {
            throw new PipelineException((Throwable)e);
        }
        context.invokeNext(request);
    }

    private synchronized void initServlet() throws PipelineException {
        if (!this.servletInitialized) {
            try {
                this.servlet.init(this.config);
                this.servletInitialized = true;
            }
            catch (Exception e) {
                throw new PipelineException((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServletConfigImpl
    implements ServletConfig {
        protected String servletName;
        protected Map<String, String> initParams;
        protected ServletContext servletContext;

        public ServletConfigImpl(String servletName, Map<String, String> initParams) {
            this(servletName, initParams, null);
        }

        public ServletConfigImpl(String servletName, Map<String, String> initParams, ServletContext servletContext) {
            this.servletName = servletName;
            this.initParams = initParams;
            this.servletContext = servletContext;
        }

        public String getInitParameter(String paramName) {
            return this.initParams.get(paramName);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.initParams.keySet());
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return this.servletName;
        }
    }
}

