/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LayoutValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerySimpleLayoutValveImpl
extends AbstractValve
implements LayoutValve {
    private static final Logger log = LoggerFactory.getLogger(VerySimpleLayoutValveImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            try {
                log.info("Invoking the VerySimpleLayoutValve...");
                HttpServletRequest httpRequest = request.getRequest();
                RequestDispatcher rd = httpRequest.getRequestDispatcher("/pages/SimpleLayoutHeader.jsp");
                rd.include((ServletRequest)httpRequest, (ServletResponse)request.getResponse());
                Stack<String> renderStack = (Stack<String>)httpRequest.getAttribute("org.apache.jetspeed.renderStack");
                if (renderStack == null) {
                    renderStack = new Stack<String>();
                    httpRequest.setAttribute("org.apache.jetspeed.renderStack", renderStack);
                }
                renderStack.push("/pages/SimpleLayoutFooter.jsp");
            }
            catch (Exception e) {
                try {
                    log.error("VerySimpleLayout: Unable to include layout header.  Layout not processed", (Throwable)e);
                    PrintWriter pw = request.getResponse().getWriter();
                    pw.write("VerySimpleLayoutFailed failed to include servlet resources. (details below) <br/>");
                    pw.write("Exception: " + e.getClass().getName() + " <br/>");
                    pw.write("Message: " + e.getMessage() + " <br/>");
                    VerySimpleLayoutValveImpl.writeStackTrace(e.getStackTrace(), pw);
                    if (e instanceof ServletException && ((ServletException)((Object)e)).getRootCause() != null) {
                        Throwable rootCause = ((ServletException)((Object)e)).getRootCause();
                        pw.write("Root Cause: " + rootCause.getClass().getName() + " <br/>");
                        pw.write("Message: " + rootCause.getMessage() + " <br/>");
                        VerySimpleLayoutValveImpl.writeStackTrace(rootCause.getStackTrace(), pw);
                    }
                }
                catch (IOException e1) {
                }
                Object var7_11 = null;
                context.invokeNext(request);
                return;
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            context.invokeNext(request);
            throw throwable;
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "VerySimpleLayoutValveImpl";
    }

    protected static final void writeStackTrace(StackTraceElement[] traceArray, PrintWriter pw) {
        pw.write("<p>Stack Trace: </p>");
        for (int i = 0; i < traceArray.length; ++i) {
            pw.write("&nbsp;&nbsp;&nbsp;" + traceArray[i].toString() + "<br />");
        }
    }
}

