/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.impl.ProfilerValveImpl;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUserTemplatePagesValveImpl
extends ProfilerValveImpl {
    private static final Logger log = LoggerFactory.getLogger(CreateUserTemplatePagesValveImpl.class);
    public static final String USER_TEMPLATE_FOLDER_REQUEST_ATTR_KEY = "org.apache.jetspeed.profiler.UserTemplateFolder";
    protected PageManager pageManager;
    protected String defaultTemplateFolder = "/_template/new-user/";

    public CreateUserTemplatePagesValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback, boolean useHistoryPageManager, PageManager pageManager) {
        super(profiler, portalSite, pageLayoutComponent, requestFallback, useHistoryPageManager);
        this.pageManager = pageManager;
    }

    public CreateUserTemplatePagesValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback, PageManager pageManager) {
        super(profiler, portalSite, pageLayoutComponent, requestFallback);
        this.pageManager = pageManager;
    }

    public CreateUserTemplatePagesValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, PageManager pageManager) {
        super(profiler, portalSite, pageLayoutComponent);
        this.pageManager = pageManager;
    }

    public void setDefaultTemplateFolder(String defaultTemplateFolder) {
        this.defaultTemplateFolder = defaultTemplateFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        boolean created = false;
        try {
            created = this.createUserFolderPages(request);
        }
        catch (Exception e) {
            log.error("Exception occurred during creating user folder.", (Throwable)e);
        }
        finally {
            if (created) {
                super.invoke(request, context);
            } else {
                context.invokeNext(request);
            }
        }
    }

    private boolean createUserFolderPages(RequestContext request) throws Exception {
        boolean created = false;
        String userName = request.getUserPrincipal().getName();
        String userFolder = "/_user/" + userName;
        boolean found = true;
        try {
            this.pageManager.getFolder(userFolder);
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        if (!found) {
            String templateFolder = (String)request.getAttribute(USER_TEMPLATE_FOLDER_REQUEST_ATTR_KEY);
            if (templateFolder == null) {
                templateFolder = this.defaultTemplateFolder;
            }
            Folder source = this.pageManager.getFolder(templateFolder);
            this.pageManager.deepCopyFolder(source, userFolder, userName);
            Folder destFolder = this.pageManager.getFolder(userFolder);
            destFolder.setTitle(userName);
            destFolder.setShortTitle(userName);
            this.pageManager.updateFolder(destFolder);
            created = true;
        }
        return created;
    }
}

