/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.security.Principal;
import java.util.HashMap;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.pipeline.valve.impl.AbstractPageValveImpl;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.request.RequestContext;

public class ProfilerValveImpl
extends AbstractPageValveImpl {
    private Profiler profiler;

    public ProfilerValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback, boolean useHistory) {
        super(portalSite, pageLayoutComponent, requestFallback, useHistory);
        this.profiler = profiler;
    }

    public ProfilerValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback) {
        this(profiler, portalSite, pageLayoutComponent, requestFallback, true);
    }

    public ProfilerValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent) {
        this(profiler, portalSite, pageLayoutComponent, true, true);
    }

    protected void setRequestPage(RequestContext request, String requestPath, Principal requestUserPrincipal) throws NodeNotFoundException, ProfilerException {
        ProfileLocator locator;
        HashMap<String, ProfileLocator> locators = null;
        String locatorName = (String)request.getAttribute("org.apache.jetspeed.profiler.ProfileLocator");
        if (locatorName != null && (locator = this.profiler.getProfile(request, locatorName)) != null) {
            locators = new HashMap<String, ProfileLocator>();
            locators.put("page", locator);
        }
        if (locators == null) {
            locators = this.profiler.getProfileLocators(request, requestUserPrincipal);
        }
        if (locators.size() == 0) {
            locators = this.profiler.getDefaultProfileLocators(request);
        }
        if (locators.size() == 0) {
            locators.put("page", this.profiler.getProfile(request, "page"));
        }
        if (locators != null) {
            String pipeline;
            PortalSiteSessionContext sessionContext = (PortalSiteSessionContext)request.getSessionAttribute("org.apache.jetspeed.portalsite.PortalSiteSessionContext");
            if (sessionContext == null || !sessionContext.isValid()) {
                sessionContext = this.portalSite.newSessionContext();
                request.setSessionAttribute("org.apache.jetspeed.portalsite.PortalSiteSessionContext", (Object)sessionContext);
            }
            boolean forceReservedFoldersVisible = (pipeline = request.getPipeline().getName()).equals("ConfigurePipeline") || pipeline.equals("DesktopConfigurePipeline");
            PortalSiteRequestContext requestContext = sessionContext.newRequestContext(locators, requestUserPrincipal.getName(), this.requestFallback, this.useHistory, forceReservedFoldersVisible, true);
            this.setRequestPage(request, requestPath, requestContext);
        }
    }

    public String toString() {
        return "ProfilerValve";
    }
}

