/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.request;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.list.TreeList;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.impl.ContentFragmentImpl;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.window.impl.PortletWindowImpl;
import org.apache.jetspeed.pipeline.Pipeline;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.request.PortalRequestFactory;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.util.HeadElementsUtils;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedRequestContext
implements RequestContext {
    protected static final Logger log = LoggerFactory.getLogger(JetspeedRequestContext.class);
    private static final String ACTION_ERROR_ATTR = "org.apache.jetspeed.action.error:";
    private static final String INSTANT_WINDOWS_SESSION_KEY = "org.apache.jetspeed.instant.windows";
    private final ThreadLocal<PortletWindow> currentWindow = new ThreadLocal();
    private RequestContextComponent rcc;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletConfig config;
    private HttpSession session;
    private Map locators;
    private ContentPage page;
    private PortletDefinition portletDefinition;
    private Subject subject;
    private Locale locale;
    private Pipeline pipeline;
    private CapabilityMap capabilityMap;
    private String mimeType;
    private String mediaType;
    private PortalURL url;
    private PortletWindow actionWindow;
    private String encoding;
    private String requestPath = null;
    private final Map<String, Object> objects;
    private final Map<String, PortletWindow> portletWindows;

    public JetspeedRequestContext(RequestContextComponent rcc, HttpServletRequest request, HttpServletResponse response, ServletConfig config) {
        this(rcc, request, response, config, new HashMap<String, Object>());
    }

    public JetspeedRequestContext(RequestContextComponent rcc, HttpServletRequest request, HttpServletResponse response, ServletConfig config, Map<String, Object> objects) {
        this.rcc = rcc;
        this.request = request;
        this.response = response;
        this.config = config;
        this.session = request.getSession();
        this.objects = objects;
        this.portletWindows = new HashMap<String, PortletWindow>();
        if (null != this.request) {
            this.request.setAttribute("org.apache.jetspeed.request.RequestContext", (Object)this);
            this.request.setAttribute("org.apache.jetspeed.context", (Object)this.request.getContextPath());
            this.request.setAttribute("org.apache.jetspeed.request.RequestContextObjects", objects);
            PortalRequestFactory prf = null;
            try {
                prf = (PortalRequestFactory)Jetspeed.getComponentManager().getComponent(PortalRequestFactory.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.request = prf != null ? prf.createPortalRequest(this.request) : new HttpServletRequestWrapper(this.request);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getConfig() {
        return this.config;
    }

    public Map getProfileLocators() {
        return this.locators;
    }

    public void setProfileLocators(Map locators) {
        this.locators = locators;
    }

    public ContentPage getPage() {
        return this.page;
    }

    public void setPage(ContentPage page) {
        this.page = page;
        if (page != null) {
            this.getRequest().setAttribute("org.apache.jetspeed.Page", (Object)page);
        }
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public void setPortletDefinition(PortletDefinition portletDefinition) {
        this.portletDefinition = portletDefinition;
    }

    public CapabilityMap getCapabilityMap() {
        return this.capabilityMap;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public PortletWindow getActionWindow() {
        return this.actionWindow;
    }

    public void setActionWindow(PortletWindow portletWindow) {
        this.actionWindow = portletWindow;
    }

    public void setCapabilityMap(CapabilityMap map) {
        this.capabilityMap = map;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(String enc) {
        String preferedEnc = (String)this.session.getAttribute("org.apache.jetspeed.prefered.characterencoding");
        if (preferedEnc == null || !enc.equals(preferedEnc)) {
            this.request.setAttribute("org.apache.jetspeed.prefered.characterencoding", (Object)enc);
        }
        this.encoding = enc;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Principal getUserPrincipal() {
        return SubjectHelper.getBestPrincipal((Subject)this.getSubject(), User.class);
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Locale preferedLocale = (Locale)this.session.getAttribute("org.apache.jetspeed.prefered.locale");
        if (preferedLocale == null || !locale.equals(preferedLocale)) {
            this.session.setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
            this.request.setAttribute("org.apache.jetspeed.prefered.locale", (Object)locale);
        }
        this.locale = locale;
    }

    public String getRequestParameter(String key) {
        return this.request.getParameter(key);
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public Object getRequestAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public Object getSessionAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public void setSessionAttribute(String key, Object value) {
        this.session.setAttribute(key, value);
    }

    public void setAttribute(String key, Object value) {
        this.request.setAttribute(key, value);
    }

    public Object getAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public String getPath() {
        if (this.requestPath == null) {
            this.requestPath = this.getPortalURL().getPath();
        }
        return this.requestPath;
    }

    public void setPortalURL(PortalURL url) {
        if (this.url != null) {
            throw new IllegalStateException("PortalURL already set");
        }
        if (url == null) {
            throw new IllegalArgumentException("PortalURL may not be nullified");
        }
        this.url = url;
    }

    public PortalURL getPortalURL() {
        return this.url;
    }

    public Map<String, String> getUserInfoMap(String appName) {
        return this.rcc.getUserInfoManager().getUserInfoMap(appName, (RequestContext)this);
    }

    public Language getPreferedLanguage(PortletDefinition portlet) {
        Language language = portlet.getLanguage(this.locale);
        if (language == null) {
            Enumeration locales = this.request.getLocales();
            while (language == null && locales.hasMoreElements()) {
                Locale aLocale = (Locale)locales.nextElement();
                language = portlet.getLanguage(aLocale);
            }
        }
        if (language == null) {
            language = portlet.getLanguage(JetspeedLocale.getDefaultLocale());
        }
        return language;
    }

    public void setPath(String path) {
        this.requestPath = path;
    }

    public Throwable popActionFailure(PortletWindow window) {
        String key = ACTION_ERROR_ATTR + window.getId();
        Throwable t = (Throwable)this.session.getAttribute(key);
        this.session.removeAttribute(key);
        return t;
    }

    public void setActionFailure(PortletWindow window, Throwable actionFailure) {
        this.setSessionAttribute(ACTION_ERROR_ATTR + window.getId(), actionFailure);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public ContentPage locatePage(Profiler profiler, PageLayoutComponent pageLayoutComponent, String nonProfiledPath) {
        try {
            String pathSave = this.getPath();
            this.setPath(nonProfiledPath);
            ContentPage realPage = this.getPage();
            this.setPage(null);
            HashMap<String, ProfileLocator> locators = null;
            ProfileLocator locator = profiler.getProfile((RequestContext)this, "page");
            if (locator != null) {
                locators = new HashMap<String, ProfileLocator>();
                locators.put("page", locator);
            }
            PortalSiteSessionContext sessionContext = (PortalSiteSessionContext)this.getSessionAttribute("org.apache.jetspeed.portalsite.PortalSiteSessionContext");
            String userPrincipal = this.getUserPrincipal() != null ? this.getUserPrincipal().getName() : null;
            PortalSiteRequestContext requestContext = sessionContext.newRequestContext(locators, userPrincipal, true, true);
            BaseFragmentsElement managedPageOrTemplate = requestContext.getManagedPageOrTemplate();
            PageTemplate managedPageTemplate = requestContext.getManagedPageTemplate();
            Map managedFragmentDefinitions = requestContext.getManagedFragmentDefinitions();
            ContentPage cpage = pageLayoutComponent.newContentPage(managedPageOrTemplate, managedPageTemplate, managedFragmentDefinitions);
            this.setPage(realPage);
            this.setPath(pathSave);
            return cpage;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public PortletWindow getCurrentPortletWindow() {
        return this.currentWindow.get();
    }

    public void setCurrentPortletWindow(PortletWindow window) {
        if (window != null && !window.isValid()) {
            throw new IllegalStateException("Invalid window: " + window.getId() + " should not be invoked");
        }
        this.currentWindow.set(window);
    }

    public PortletWindow getPortletWindow(String windowId) {
        return this.portletWindows.get(windowId);
    }

    public PortletWindow getPortletWindow(ContentFragment fragment) {
        PortletWindow window = this.portletWindows.get(fragment.getId());
        if (window == null) {
            window = this.createPortletWindow(fragment);
        }
        return window;
    }

    public PortletWindow getInstantlyCreatedPortletWindow(String windowId, String portletUniqueName) {
        if (this.portletWindows.get(windowId) != null) {
            throw new IllegalArgumentException("PortletWindow " + windowId + " already exists");
        }
        return this.getInstantlyCreatedPortletWindow(windowId, portletUniqueName, true);
    }

    public PortletWindow resolvePortletWindow(String windowId) {
        PortletWindow window = this.portletWindows.get(windowId);
        if (window == null) {
            this.getPage().getRootFragment();
            ContentFragment fragment = this.getPage().getFragmentById(windowId);
            window = fragment == null ? this.getInstantlyCreatedPortletWindow(windowId, null, false) : this.createPortletWindow(fragment);
        }
        return window;
    }

    private PortletWindow createPortletWindow(ContentFragment fragment) {
        PortletWindowImpl window = null;
        PortletDefinition pd = this.rcc.getPortletRegistry().getPortletDefinitionByUniqueName(fragment.getName(), true);
        if (pd != null) {
            window = new PortletWindowImpl((RequestContext)this, fragment, pd);
        } else {
            window = new PortletWindowImpl((RequestContext)this, fragment);
            fragment.overrideRenderedContent("Failed to retrieve Portlet Definition for " + fragment.getName());
            log.error(fragment.getOverriddenContent());
        }
        this.portletWindows.put(window.getWindowId(), (PortletWindow)window);
        return window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletWindow getInstantlyCreatedPortletWindow(String windowId, String portletUniqueName, boolean register) {
        boolean registered = false;
        HttpSession session = this.getRequest().getSession();
        if (session != null) {
            String uniqueName;
            Map instantWindows;
            Map pages = null;
            HttpSession httpSession = session;
            synchronized (httpSession) {
                pages = (Map)session.getAttribute(INSTANT_WINDOWS_SESSION_KEY);
            }
            if (pages != null && (instantWindows = (Map)pages.get(this.getPage().getId())) != null && (uniqueName = (String)instantWindows.get(windowId)) != null) {
                if (portletUniqueName != null) {
                    if (!portletUniqueName.equals(uniqueName)) {
                        instantWindows.put(windowId, portletUniqueName);
                    }
                } else {
                    portletUniqueName = uniqueName;
                }
                registered = true;
            }
        }
        PortletWindow window = null;
        if (portletUniqueName != null) {
            ContentFragmentImpl fragment = new ContentFragmentImpl(windowId, true);
            fragment.setType("portlet");
            fragment.setName(portletUniqueName);
            window = this.createPortletWindow((ContentFragment)fragment);
            if (register && !registered && window.isValid()) {
                if (session == null) {
                    session = this.getRequest().getSession(true);
                }
                Map pages = null;
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    pages = (Map)session.getAttribute(INSTANT_WINDOWS_SESSION_KEY);
                    if (pages == null) {
                        pages = Collections.synchronizedMap(new HashMap());
                        session.setAttribute(INSTANT_WINDOWS_SESSION_KEY, pages);
                    }
                }
                String pageId = this.getPage().getId();
                Map<String, String> instantWindows = (Map<String, String>)pages.get(pageId);
                if (instantWindows == null) {
                    instantWindows = Collections.synchronizedMap(new HashMap());
                    pages.put(pageId, instantWindows);
                }
                instantWindows.put(windowId, portletUniqueName);
            }
        }
        return window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstantlyCreatedPortletWindow(PortletWindow portletWindow) {
        if (!portletWindow.isValid()) {
            throw new IllegalStateException("Invalid window " + portletWindow.getId() + " should not be registered");
        }
        HttpSession session = this.getRequest().getSession(true);
        Map pages = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            pages = (Map)session.getAttribute(INSTANT_WINDOWS_SESSION_KEY);
            if (pages == null) {
                pages = Collections.synchronizedMap(new HashMap());
                session.setAttribute(INSTANT_WINDOWS_SESSION_KEY, pages);
            }
        }
        String pageId = this.getPage().getId();
        Map<String, String> instantWindows = (Map<String, String>)pages.get(pageId);
        if (instantWindows == null) {
            instantWindows = Collections.synchronizedMap(new HashMap());
            pages.put(pageId, instantWindows);
        }
        instantWindows.put(portletWindow.getWindowId(), portletWindow.getPortletDefinition().getUniqueName());
    }

    public boolean ensureThreadContext() {
        RequestContext current = this.rcc.getRequestContext();
        this.rcc.setRequestContext((RequestContext)this);
        return current == null || current != this;
    }

    public void clearThreadContext() {
        this.rcc.setRequestContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValue<String, HeadElement>> getMergedHeadElements() {
        ContentPage page = this.getPage();
        ContentFragment root = page.getRootFragment();
        List headElements = this.getPortletWindow(root).getHeadElements();
        HttpSession session = this.getRequest().getSession();
        if (session == null) {
            return headElements;
        }
        Map pages = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            pages = (Map)session.getAttribute(INSTANT_WINDOWS_SESSION_KEY);
        }
        if (pages == null) {
            return headElements;
        }
        Map instantWindows = (Map)pages.get(page.getId());
        if (instantWindows == null || instantWindows.isEmpty()) {
            return headElements;
        }
        ArrayList windowIds = null;
        Map map = instantWindows;
        synchronized (map) {
            windowIds = new ArrayList(instantWindows.keySet());
        }
        if (windowIds.isEmpty()) {
            return headElements;
        }
        TreeList mergedHeadElements = new TreeList((Collection)headElements);
        for (String windowId : windowIds) {
            PortletWindow window = this.portletWindows.get(windowId);
            if (window == null) continue;
            HeadElementsUtils.aggregateHeadElements((List)mergedHeadElements, (List)window.getHeadElements());
        }
        HeadElementsUtils.mergeHeadElementsByHint((List)mergedHeadElements);
        return mergedHeadElements;
    }
}

