/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.request;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.request.JetspeedRequestContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.apache.jetspeed.userinfo.UserInfoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedRequestContextComponent
implements RequestContextComponent {
    private PortletRegistry registry;
    private UserInfoManager userInfoMgr;
    private Map<String, Object> requestContextObjects;
    private ThreadLocal<RequestContext> tlRequestContext = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(JetspeedRequestContextComponent.class);

    public JetspeedRequestContextComponent(PortletRegistry registry, UserInfoManager userInfoMgr, Map<String, Object> requestContextObjects) {
        this.registry = registry;
        this.userInfoMgr = userInfoMgr;
        this.requestContextObjects = requestContextObjects;
    }

    public RequestContext create(HttpServletRequest request, HttpServletResponse response, ServletConfig config) {
        JetspeedRequestContext context = null;
        try {
            context = new JetspeedRequestContext(this, request, response, config, this.requestContextObjects);
        }
        catch (Exception e) {
            String msg = "JetspeedRequestContextComponent: Failed to create a Class object for RequestContext: " + e.toString();
            log.error(msg);
        }
        this.setRequestContext(context);
        return context;
    }

    public void setRequestContext(RequestContext context) {
        this.tlRequestContext.set(context);
    }

    public RequestContext getRequestContext() {
        return this.tlRequestContext.get();
    }

    public PortletRegistry getPortletRegistry() {
        return this.registry;
    }

    public UserInfoManager getUserInfoManager() {
        return this.userInfoMgr;
    }
}

