/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.request;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jetspeed.container.url.PortalURL;
import org.apache.jetspeed.request.RequestDiagnostics;
import org.apache.jetspeed.request.RequestDiagnosticsFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDiagnosticsImpl
implements RequestDiagnostics {
    private static final long serialVersionUID = -2516862911706710811L;
    private static final Logger logger = RequestDiagnosticsFactory.getLogger();
    private static long idBase = System.currentTimeMillis();
    protected static final String LOG_LINE_PREFIX = "  ";
    protected static final String LOG_FIELD_POSTFIX = ": ";
    protected static final String DATE_FORMAT = "z yyyy-MM-dd HH:mm:ss:SSS";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String id;
    private final String timeRecorded;
    private final String thread;
    private boolean internal;
    private String server;
    private String remoteAddr;
    private String localAddr;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String requestURI;
    private String requestMethod;
    private String pagePath;
    private String pageId;
    private PortalURL.URLType portalURLType;
    private String portletApplicationName;
    private String portletName;
    private String portletWindowId;
    private String userPrincipalName;
    private Throwable exception;
    private Throwable cause;
    private String errorMessage;
    private String errorDescription;
    private Map<String, Serializable> attributes;
    private transient StringBuilder logBuilder;
    private transient LogLevel logLevel;

    public RequestDiagnosticsImpl() {
        this(RequestDiagnosticsImpl.nextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextId() {
        Class<RequestDiagnosticsImpl> clazz = RequestDiagnosticsImpl.class;
        synchronized (RequestDiagnosticsImpl.class) {
            long nextId = idBase++;
            // ** MonitorExit[var2] (shouldn't be in output)
            return Long.toString(nextId, 36).toUpperCase();
        }
    }

    protected RequestDiagnosticsImpl(String id) {
        this.id = id;
        this.timeRecorded = this.formatDate(new Date());
        this.thread = Thread.currentThread().toString();
    }

    public String getId() {
        return this.id;
    }

    public String getTimeRecorded() {
        return this.timeRecorded;
    }

    public String getThread() {
        return this.thread;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPath() {
        if (this.contextPath != null) {
            StringBuilder sb = new StringBuilder(this.contextPath);
            if (this.servletPath != null) {
                sb.append(this.servletPath);
            }
            if (this.pagePath != null) {
                sb.append(this.pagePath);
            }
            return sb.toString();
        }
        return null;
    }

    public PortalURL.URLType getPortalURLType() {
        return this.portalURLType;
    }

    public void setPortalURLType(PortalURL.URLType portalURLType) {
        this.portalURLType = portalURLType;
    }

    public String getPortletApplicationName() {
        return this.portletApplicationName;
    }

    public void setPortletApplicationName(String portletApplicationName) {
        this.portletApplicationName = portletApplicationName;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public String getPortletWindowId() {
        return this.portletWindowId;
    }

    public void setPortletWindowId(String portletWindowId) {
        this.portletWindowId = portletWindowId;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public void setUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorDescription() {
        return this.errorDescription != null ? this.errorDescription : this.errorMessage;
    }

    public void setErrorDescription(String value) {
        this.errorDescription = value;
    }

    public boolean isAttributesEmpty() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    public Map<String, Serializable> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Serializable>();
        }
        return this.attributes;
    }

    public void logAsInfo() {
        if (logger.isInfoEnabled()) {
            this.log(LogLevel.INFO);
        }
    }

    public void logAsWarning() {
        if (logger.isWarnEnabled()) {
            this.log(LogLevel.WARNING);
        }
    }

    public void logAsError() {
        if (logger.isErrorEnabled()) {
            this.log(LogLevel.ERROR);
        }
    }

    public void logAsDebug() {
        if (logger.isDebugEnabled()) {
            this.log(LogLevel.DEBUG);
        }
    }

    public void logAsTrace() {
        if (logger.isTraceEnabled()) {
            this.log(LogLevel.TRACE);
        }
    }

    protected String formatDate(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    protected void createLog(LogLevel level) {
        this.logBuilder = new StringBuilder();
        this.logLevel = level;
    }

    protected LogLevel getCurrentLogLevel() {
        return this.logLevel;
    }

    protected void initLog() {
        this.logBuilder.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
    }

    protected void writeLog() {
        if (this.logBuilder != null && this.logBuilder.length() > 0) {
            LogLevel level = this.getCurrentLogLevel();
            if (LogLevel.INFO == level) {
                logger.info(this.logBuilder.toString());
            } else if (LogLevel.WARNING == level) {
                logger.warn(this.logBuilder.toString());
            } else if (LogLevel.ERROR == level) {
                logger.error(this.logBuilder.toString());
            } else if (LogLevel.DEBUG == level) {
                logger.debug(this.logBuilder.toString());
            } else if (LogLevel.TRACE == level) {
                logger.trace(this.logBuilder.toString());
            }
        }
    }

    protected void finalizeLog() {
    }

    protected void closeLog() {
        this.logBuilder = null;
        this.logLevel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(LogLevel level) {
        try {
            this.createLog(level);
            this.initLog();
            this.logElements();
            this.finalizeLog();
            this.writeLog();
            Object var3_2 = null;
            this.closeLog();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeLog();
            throw throwable;
        }
    }

    protected void logElements() {
        this.logId();
        this.logTimeRecorded();
        this.logThread();
        this.logInternal();
        this.logUserPrincipalName();
        this.logServer();
        this.logRemoteAddr();
        this.logLocalAddr();
        this.logContextPath();
        this.logServletPath();
        this.logPathInfo();
        this.logQueryString();
        this.logRequestURI();
        this.logPortalURLType();
        this.logRequestMethod();
        this.logPagePath();
        this.logPageId();
        this.logPortletApplicationName();
        this.logPortletName();
        this.logPortletWindowId();
        this.logErrorDescription();
        this.logErrorMessage();
        this.logException();
        this.logCause();
        this.logAttributes();
    }

    protected void logId() {
        this.addElementToLog("Id", this.id, true);
    }

    protected void logTimeRecorded() {
        this.addElementToLog("Time", this.timeRecorded, true);
    }

    protected void logThread() {
        this.addElementToLog("Thread", this.thread, true);
    }

    protected void logInternal() {
        this.addElementToLog("Internal", Boolean.toString(this.internal), true);
    }

    protected void logServer() {
        this.addElementToLog("Server", this.server, false);
    }

    protected void logRemoteAddr() {
        this.addElementToLog("Remote IP address", this.remoteAddr, false);
    }

    protected void logLocalAddr() {
        this.addElementToLog("Local IP address", this.localAddr, false);
    }

    protected void logContextPath() {
        this.addElementToLog("Context path", this.contextPath, false);
    }

    protected void logServletPath() {
        this.addElementToLog("Servlet path", this.servletPath, false);
    }

    protected void logPathInfo() {
        this.addElementToLog("Path info", this.pathInfo, false);
    }

    protected void logQueryString() {
        this.addElementToLog("Query string", this.queryString, false);
    }

    protected void logRequestURI() {
        this.addElementToLog("Request URI", this.requestURI, false);
    }

    protected void logRequestMethod() {
        this.addElementToLog("Request method", this.requestMethod, false);
    }

    protected void logPagePath() {
        this.addElementToLog("Page path", this.pagePath, false);
    }

    protected void logPageId() {
        this.addElementToLog("Page id", this.pageId, false);
    }

    protected void logPortalURLType() {
        if (this.portalURLType != null) {
            this.addElementToLog("URL type", this.portalURLType.toString(), true);
        }
    }

    protected void logPortletApplicationName() {
        this.addElementToLog("Portlet application", this.portletApplicationName, false);
    }

    protected void logPortletName() {
        this.addElementToLog("Portlet", this.portletName, false);
    }

    protected void logPortletWindowId() {
        this.addElementToLog("Portlet window id", this.portletWindowId, false);
    }

    protected void logUserPrincipalName() {
        this.addElementToLog("User", this.userPrincipalName, false);
    }

    protected void logErrorDescription() {
        this.addElementToLog("Error description", this.errorDescription, false);
    }

    protected void logErrorMessage() {
        this.addElementToLog("Error message", this.errorMessage, false);
    }

    protected void logException() {
        if (this.exception != null) {
            this.addElementExceptionToLog("Exception", this.exception);
        }
    }

    protected void logCause() {
        if (this.cause != null && this.exception == null) {
            this.addElementExceptionToLog("Cause", this.cause);
        }
    }

    protected void logAttributes() {
        if (!this.isAttributesEmpty()) {
            this.addElementToLog("Attributes", null, true);
            int seq = 0;
            for (Map.Entry<String, Serializable> entry : this.getAttributes().entrySet()) {
                this.addElementDetailToLog("Attributes", entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null, seq++);
            }
        }
    }

    protected void addLinePrefixToLog(int num) {
        for (int i = 0; i < num; ++i) {
            this.logBuilder.append(LOG_LINE_PREFIX);
        }
    }

    protected void addElementToLog(String element, String value, boolean empty) {
        if (empty || value != null) {
            this.logBuilder.append(LOG_LINE_PREFIX);
            this.logBuilder.append(element);
            this.logBuilder.append(LOG_FIELD_POSTFIX);
            if (value != null) {
                this.logBuilder.append(value);
            }
            this.logBuilder.append(LINE_SEPARATOR);
        }
    }

    protected void addElementDetailToLog(String element, String detail, String value, int seq) {
        this.logBuilder.append(LOG_LINE_PREFIX);
        this.logBuilder.append(LOG_LINE_PREFIX);
        this.logBuilder.append(detail);
        this.logBuilder.append(LOG_FIELD_POSTFIX);
        if (value != null) {
            this.logBuilder.append(value);
        }
        this.logBuilder.append(LINE_SEPARATOR);
    }

    protected void addElementExceptionToLog(String element, Throwable t) {
        block13: {
            try {
                this.logBuilder.append(LOG_LINE_PREFIX);
                this.logBuilder.append(element);
                this.logBuilder.append(LOG_FIELD_POSTFIX);
                if (t != null) {
                    this.logBuilder.append(t.toString());
                    this.logBuilder.append(LINE_SEPARATOR);
                    StackTraceElement[] stackTrace = t.getStackTrace();
                    if (stackTrace != null && stackTrace.length != 0) {
                        for (int i = 0; i < stackTrace.length; ++i) {
                            this.logBuilder.append(LOG_LINE_PREFIX).append(LOG_LINE_PREFIX);
                            this.logBuilder.append("at: ").append(stackTrace[i].toString());
                            this.logBuilder.append(LINE_SEPARATOR);
                        }
                    } else {
                        this.logBuilder.append(LOG_LINE_PREFIX).append(LOG_LINE_PREFIX);
                        this.logBuilder.append("<no stack trace available>");
                        this.logBuilder.append(LINE_SEPARATOR);
                    }
                    Throwable wCause = t;
                    int prefixLevel = 2;
                    while (wCause != wCause.getCause() && wCause.getCause() != null) {
                        StackTraceElement[] parentStackTrace = wCause.getStackTrace();
                        wCause = wCause.getCause();
                        this.addLinePrefixToLog(prefixLevel);
                        this.logBuilder.append("caused by: ").append(wCause.toString());
                        this.logBuilder.append(LINE_SEPARATOR);
                        ++prefixLevel;
                        StackTraceElement[] causeStackTrace = wCause.getStackTrace();
                        if (causeStackTrace != null && causeStackTrace.length != 0) {
                            if (parentStackTrace == null || parentStackTrace.length == 0) {
                                for (int i = 0; i < causeStackTrace.length; ++i) {
                                    this.addLinePrefixToLog(prefixLevel);
                                    this.logBuilder.append("at: ").append(causeStackTrace[i].toString());
                                    this.logBuilder.append(LINE_SEPARATOR);
                                }
                                continue;
                            }
                            int thisCount = causeStackTrace.length - 1;
                            int framesEqual = 0;
                            for (int parentCount = parentStackTrace.length - 1; parentCount > -1 && thisCount > -1 && causeStackTrace[thisCount].equals(parentStackTrace[parentCount]); --thisCount, --parentCount) {
                                ++framesEqual;
                            }
                            if (framesEqual > 1) {
                                --framesEqual;
                            }
                            int len = causeStackTrace.length - framesEqual;
                            for (int i = 0; i < len; ++i) {
                                this.addLinePrefixToLog(prefixLevel);
                                this.logBuilder.append("at: ").append(causeStackTrace[i].toString());
                                this.logBuilder.append(LINE_SEPARATOR);
                            }
                            if (framesEqual <= 0) continue;
                            this.addLinePrefixToLog(prefixLevel);
                            this.logBuilder.append("... ").append(framesEqual).append(" more");
                            this.logBuilder.append(LINE_SEPARATOR);
                            continue;
                        }
                        this.addLinePrefixToLog(prefixLevel);
                        this.logBuilder.append("<no stack trace available>");
                        this.logBuilder.append(LINE_SEPARATOR);
                    }
                    break block13;
                }
                this.logBuilder.append(LINE_SEPARATOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LogLevel {
        INFO,
        WARNING,
        ERROR,
        DEBUG,
        TRACE;

    }
}

