/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.resource;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedHttpServletResponse
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream byteOutputBuffer;
    private CharArrayWriterBuffer charOutputBuffer;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private HashMap<String, ArrayList<String>> headers;
    private ArrayList<Cookie> cookies;
    private int errorCode;
    private int statusCode;
    private String errorMessage;
    private String redirectLocation;
    private boolean committed;
    private boolean hasStatus;
    private boolean hasError;
    private Locale locale;
    private boolean closed;
    private String characterEncoding;
    private boolean setContentTypeAfterEncoding;
    private int contentLength = -1;
    private String contentType;
    private boolean flushed;

    public BufferedHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void flush(HttpServletResponse response) throws IOException {
        if (this.flushed) {
            throw new IllegalStateException("Already flushed");
        }
        this.flushed = true;
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                response.addCookie(cookie);
            }
            this.cookies = null;
        }
        if (this.locale != null) {
            response.setLocale(this.locale);
        }
        if (this.contentType != null) {
            if (this.characterEncoding != null) {
                if (this.setContentTypeAfterEncoding) {
                    response.setCharacterEncoding(this.characterEncoding);
                    response.setContentType(this.contentType);
                } else {
                    response.setContentType(this.contentType);
                    response.setCharacterEncoding(this.characterEncoding);
                }
            } else {
                response.setContentType(this.contentType);
            }
        } else if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                for (String value : (ArrayList)entry.getValue()) {
                    response.addHeader((String)entry.getKey(), value);
                }
            }
            this.headers = null;
        }
        if (this.contentLength > -1) {
            response.setContentLength(this.contentLength);
        }
        if (this.hasStatus) {
            response.setStatus(this.statusCode);
        }
        if (this.hasError) {
            response.sendError(this.errorCode, this.errorMessage);
        } else if (this.redirectLocation != null) {
            response.sendRedirect(this.redirectLocation);
        } else if (this.outputStream != null) {
            int n;
            if (!this.closed) {
                this.outputStream.flush();
            }
            ServletOutputStream realOutputStream = response.getOutputStream();
            int n2 = this.byteOutputBuffer.size();
            if (this.contentLength > -1 && this.contentLength < n2) {
                n = this.contentLength;
            }
            if (n > 0) {
                realOutputStream.write(this.byteOutputBuffer.toByteArray(), 0, n);
            }
            this.outputStream.close();
            this.outputStream = null;
            this.byteOutputBuffer = null;
        } else if (this.printWriter != null && !this.closed) {
            this.printWriter.flush();
            if (this.charOutputBuffer.getCount() > 0) {
                response.getWriter().write(this.charOutputBuffer.getBuffer(), 0, this.charOutputBuffer.getCount());
            }
            this.printWriter.close();
            this.printWriter = null;
            this.charOutputBuffer = null;
        }
    }

    private ArrayList<String> getHeaderList(String name, boolean create) {
        ArrayList<String> headerList;
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        if ((headerList = this.headers.get(name)) == null && create) {
            headerList = new ArrayList();
            this.headers.put(name, headerList);
        }
        return headerList;
    }

    private void failIfCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Response is already committed");
        }
    }

    public void addCookie(Cookie cookie) {
        if (!this.committed) {
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.add(cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this.committed) {
            this.addHeader(name, Long.toString(date));
        }
    }

    public void addHeader(String name, String value) {
        if (!this.committed) {
            this.getHeaderList(name, true).add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.committed) {
            this.addHeader(name, Integer.toString(value));
        }
    }

    public boolean containsHeader(String name) {
        return this.getHeaderList(name, false) != null;
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        this.failIfCommitted();
        this.committed = true;
        this.closed = true;
        this.hasError = true;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void sendError(int errorCode) throws IOException {
        this.sendError(errorCode, null);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        this.failIfCommitted();
        this.closed = true;
        this.committed = true;
        this.redirectLocation = redirectLocation;
    }

    public void setDateHeader(String name, long date) {
        if (!this.committed) {
            this.setHeader(name, Long.toString(date));
        }
    }

    public void setHeader(String name, String value) {
        if (!this.committed) {
            ArrayList<String> headerList = this.getHeaderList(name, true);
            headerList.clear();
            headerList.add(value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this.committed) {
            this.setHeader(name, Integer.toString(value));
        }
    }

    public void setStatus(int statusCode, String message) {
        throw new UnsupportedOperationException("This method is deprecated and no longer available");
    }

    public void setStatus(int statusCode) {
        if (!this.committed) {
            this.statusCode = statusCode;
            this.hasStatus = true;
            this.resetBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        if (!this.closed) {
            this.committed = true;
        }
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding != null ? this.characterEncoding : "ISO-8859-1";
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : super.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.printWriter != null) {
                throw new IllegalStateException("getWriter() has already been called on this response");
            }
            this.byteOutputBuffer = new ByteArrayOutputStream();
            this.outputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    if (!BufferedHttpServletResponse.this.closed) {
                        BufferedHttpServletResponse.this.byteOutputBuffer.write(b);
                        if (BufferedHttpServletResponse.this.contentLength > -1 && BufferedHttpServletResponse.this.byteOutputBuffer.size() >= BufferedHttpServletResponse.this.contentLength) {
                            BufferedHttpServletResponse.this.committed = true;
                            BufferedHttpServletResponse.this.closed = true;
                        }
                    }
                }
            };
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response");
            }
            this.charOutputBuffer = new CharArrayWriterBuffer();
            this.printWriter = new PrintWriter(this.charOutputBuffer);
        }
        return this.printWriter;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.headers = null;
        this.cookies = null;
        this.hasStatus = false;
        this.contentLength = -1;
        if (this.printWriter == null) {
            this.contentType = null;
            this.characterEncoding = null;
            this.locale = null;
        }
    }

    public void resetBuffer() {
        this.failIfCommitted();
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.byteOutputBuffer.reset();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
            this.charOutputBuffer.reset();
        }
    }

    public void setBufferSize(int size) {
        this.failIfCommitted();
        if (this.charOutputBuffer != null && this.charOutputBuffer.size() > 0 || this.byteOutputBuffer != null && this.byteOutputBuffer.size() > 0) {
            throw new IllegalStateException("Content has already been written");
        }
    }

    public void setCharacterEncoding(String charset) {
        if (charset != null && !this.committed && this.printWriter == null) {
            this.characterEncoding = charset;
            this.setContentTypeAfterEncoding = false;
        }
    }

    public void setContentLength(int len) {
        if (!this.committed && this.printWriter == null && len > 0) {
            this.contentLength = len;
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.closed && this.byteOutputBuffer != null && this.byteOutputBuffer.size() >= len) {
                this.committed = true;
                this.closed = true;
            }
        }
    }

    public void setContentType(String type) {
        if (!this.committed) {
            this.contentType = type;
            this.setContentTypeAfterEncoding = false;
            if (this.printWriter == null) {
                // empty if block
            }
        }
    }

    public void setLocale(Locale locale) {
        if (!this.committed) {
            this.locale = locale;
        }
    }

    private static class CharArrayWriterBuffer
    extends CharArrayWriter {
        private CharArrayWriterBuffer() {
        }

        public char[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

