/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.SecurityValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.JSSubject;

public abstract class AbstractSecurityValve
extends AbstractValve
implements SecurityValve {
    protected PortalAuthenticationConfiguration authenticationConfiguration = null;

    protected abstract Subject getSubject(RequestContext var1) throws Exception;

    protected abstract Principal getUserPrincipal(RequestContext var1) throws Exception;

    protected final Subject getSubjectFromSession(RequestContext request) throws Exception {
        return (Subject)request.getRequest().getSession().getAttribute("org.apache.jetspeed.security.subject");
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        Subject subject;
        if (this.isSessionExpired(request)) {
            return;
        }
        try {
            subject = this.getSubject(request);
        }
        catch (Exception e1) {
            throw new PipelineException(e1.getMessage(), (Throwable)e1);
        }
        request.getRequest().getSession().setAttribute("org.apache.jetspeed.security.subject", (Object)subject);
        request.setSubject(subject);
        final ValveContext vc = context;
        final RequestContext rc = request;
        PipelineException pe = (PipelineException)((Object)JSSubject.doAsPrivileged((Subject)subject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    vc.invokeNext(rc);
                    return null;
                }
                catch (PipelineException e) {
                    return e;
                }
            }
        }, null));
        if (pe != null) {
            throw pe;
        }
    }

    protected boolean isSessionExpired(RequestContext request) throws PipelineException {
        if (this.authenticationConfiguration != null && this.authenticationConfiguration.isMaxSessionHardLimitEnabled()) {
            HttpSession session = request.getRequest().getSession();
            long sessionCreationTime = session.getCreationTime();
            long currentTime = System.currentTimeMillis();
            if (currentTime - sessionCreationTime > this.authenticationConfiguration.getMsMaxSessionHardLimit()) {
                session.invalidate();
                String redirector = request.getRequest().getContextPath() + this.authenticationConfiguration.getTimeoutRedirectLocation();
                try {
                    request.getResponse().sendRedirect(redirector);
                }
                catch (IOException e) {
                    throw new PipelineException((Throwable)e);
                }
                return true;
            }
        }
        return false;
    }
}

