/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import javax.mail.internet.MimeUtility;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.SecurityException;

public class Jetspeed1CredentialPasswordEncoder
implements CredentialPasswordEncoder {
    protected String passwordsAlgorithm = "SHA";
    protected String encodingMethod = "base64";

    public Jetspeed1CredentialPasswordEncoder() {
        this("SHA", "base64");
    }

    public Jetspeed1CredentialPasswordEncoder(String algorithm) {
        this(algorithm, "base64");
    }

    public Jetspeed1CredentialPasswordEncoder(String algorithm, String encoding) {
        this.passwordsAlgorithm = algorithm;
        this.encodingMethod = encoding;
    }

    public String encode(String userName, String clearTextPassword) throws SecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordsAlgorithm);
            byte[] digest = md.digest(clearTextPassword.getBytes("UTF-8"));
            ByteArrayOutputStream bas = new ByteArrayOutputStream(digest.length + digest.length / 3 + 1);
            OutputStream encodedStream = MimeUtility.encode((OutputStream)bas, (String)"base64");
            encodedStream.write(digest);
            encodedStream.flush();
            encodedStream.close();
            return bas.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

