/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.PasswordCredentialValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.UserCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordCredentialValveImpl
extends AbstractValve
implements PasswordCredentialValve {
    private static final Logger log = LoggerFactory.getLogger(PasswordCredentialValveImpl.class);
    private static final String CHECKED_KEY = PasswordCredentialValveImpl.class.getName() + ".checked";
    private int[] expirationWarningDays;
    private String passwordResetPage = "/my-account.psml";

    public PasswordCredentialValveImpl() {
        this.expirationWarningDays = new int[0];
    }

    public PasswordCredentialValveImpl(String passwordResetPage) {
        this();
        this.passwordResetPage = passwordResetPage;
    }

    public PasswordCredentialValveImpl(List expirationWarningDays, String passwordResetPage) {
        this(expirationWarningDays);
        this.passwordResetPage = passwordResetPage;
    }

    public PasswordCredentialValveImpl(List expirationWarningDays) {
        if (expirationWarningDays != null) {
            this.expirationWarningDays = new int[expirationWarningDays.size()];
            for (int i = 0; i < this.expirationWarningDays.length; ++i) {
                this.expirationWarningDays[i] = Integer.parseInt((String)expirationWarningDays.get(i));
            }
            Arrays.sort(this.expirationWarningDays);
        } else {
            this.expirationWarningDays = new int[0];
        }
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            if (request.getRequest().getUserPrincipal() != null) {
                Subject subject = request.getSubject();
                UserCredential userCredential = SubjectHelper.getUserCredential((Subject)subject);
                Integer passwordDaysValid = null;
                if (userCredential != null) {
                    if (userCredential.isUpdateRequired()) {
                        passwordDaysValid = new Integer(0);
                    }
                    if (request.getSessionAttribute(CHECKED_KEY) == null) {
                        request.setSessionAttribute(CHECKED_KEY, (Object)Boolean.TRUE);
                        if (userCredential.getPreviousAuthenticationDate() != null && userCredential.getLastAuthenticationDate() != null && userCredential.getExpirationDate() != null) {
                            long lastAuthTime;
                            long expirationTime = userCredential.getExpirationDate().getTime();
                            int lastAuthDaysBeforeExpiration = (int)((expirationTime - (lastAuthTime = userCredential.getLastAuthenticationDate().getTime())) / 86400000L);
                            if (lastAuthDaysBeforeExpiration < 1) {
                                passwordDaysValid = new Integer(1);
                            } else if (this.expirationWarningDays.length > 0) {
                                int prevAuthDaysBeforeExpiration;
                                long prevAuthTime = Long.MIN_VALUE;
                                if (userCredential.getPreviousAuthenticationDate() != null) {
                                    prevAuthTime = userCredential.getPreviousAuthenticationDate().getTime();
                                }
                                if ((prevAuthDaysBeforeExpiration = (int)((expirationTime - prevAuthTime) / 86400000L)) > lastAuthDaysBeforeExpiration) {
                                    for (int i = 0; i < this.expirationWarningDays.length; ++i) {
                                        int daysBefore = this.expirationWarningDays[i] - 1;
                                        if (lastAuthDaysBeforeExpiration != daysBefore && (lastAuthDaysBeforeExpiration >= daysBefore || prevAuthDaysBeforeExpiration <= daysBefore)) continue;
                                        passwordDaysValid = new Integer(lastAuthDaysBeforeExpiration + 1);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (passwordDaysValid != null) {
                    if (Jetspeed.getConfiguration().getString("jetui.customization.method").equals("server")) {
                        request.setAttribute("org.apache.jetspeed.profiler.ProfileLocator", (Object)"security");
                    } else {
                        request.setAttribute("org.apache.jetspeed.Path", (Object)this.passwordResetPage);
                    }
                    request.setAttribute(PasswordCredential.PASSWORD_CREDENTIAL_DAYS_VALID_REQUEST_ATTR_KEY, (Object)passwordDaysValid);
                }
            }
            context.invokeNext(request);
        }
        catch (Exception e) {
            log.error("Exception in request pipeline: " + e.getMessage(), (Throwable)e);
            throw new PipelineException(e.toString(), (Throwable)e);
        }
    }

    public String toString() {
        return "PasswordCredentialValve";
    }
}

