/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.security.PermissionFactory;
import org.apache.jetspeed.security.SecurityAccessController;

public class SecurityAccessControllerImpl
implements SecurityAccessController {
    protected PermissionFactory pf;
    protected PageManager pageManager;
    protected int securityMode = 1;

    public SecurityAccessControllerImpl(PermissionFactory pf, PageManager pageManager, int securityMode) {
        this.pf = pf;
        this.pageManager = pageManager;
        this.securityMode = securityMode;
    }

    public int getSecurityMode() {
        return this.securityMode;
    }

    public boolean checkPortletAccess(PortletDefinition portlet, int mask) {
        if (portlet == null) {
            return false;
        }
        if (this.securityMode == 2) {
            String constraintRef = portlet.getJetspeedSecurityConstraint();
            if (constraintRef == null && (constraintRef = portlet.getApplication().getJetspeedSecurityConstraint()) == null) {
                return true;
            }
            String actions = JetspeedActions.getContainerActions((int)mask);
            return this.pageManager.checkConstraint(constraintRef, actions);
        }
        try {
            AccessController.checkPermission((Permission)this.pf.newPermission("portlet", portlet.getUniqueName(), mask));
        }
        catch (AccessControlException ace) {
            return false;
        }
        return true;
    }
}

