/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.cas;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.administration.RegistrationException;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.login.filter.PortalRequestWrapper;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;

public class CASPortalFilter
implements Filter {
    public static String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    protected String guest = "guest";

    public void init(FilterConfig filterConfig) throws ServletException {
        PortalConfiguration config = Jetspeed.getConfiguration();
        if (config != null) {
            this.guest = config.getString("default.user.principal");
        }
    }

    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = null;
        if (sRequest instanceof HttpServletRequest) {
            Subject subject;
            request = (HttpServletRequest)sRequest;
            ComponentManager cm = Jetspeed.getComponentManager();
            UserManager userManager = (UserManager)cm.getComponent((Object)"org.apache.jetspeed.security.UserManager");
            HttpSession session = request.getSession(true);
            String userName = (String)session.getAttribute(CAS_FILTER_USER);
            System.out.println("user: " + userName);
            RoleManager roleManager = (RoleManager)cm.getComponent((Object)"org.apache.jetspeed.security.RoleManager");
            GroupManager groupManager = (GroupManager)cm.getComponent((Object)"org.apache.jetspeed.security.GroupManager");
            User user = null;
            try {
                user = userManager.getUser(userName);
            }
            catch (SecurityException e) {
                System.out.println("user: " + userName + " not in j2 db");
                PortalAdministration portalAdministration = (PortalAdministration)cm.getComponent((Object)"PortalAdministration");
                try {
                    List roles = roleManager.getRoles("user");
                    List groups = groupManager.getGroups("");
                    portalAdministration.registerUser(userName, portalAdministration.generatePassword());
                }
                catch (RegistrationException e1) {
                    System.out.println("user: " + userName + " not created");
                }
                catch (SecurityException e1) {
                    System.out.println("user: " + userName + " not created");
                }
            }
            try {
                subject = userManager.getSubject(user);
            }
            catch (SecurityException e) {
                throw new ServletException((Throwable)e);
            }
            sRequest = this.wrapperRequest(request, subject, (Principal)user);
            request.getSession().removeAttribute("org.apache.jetspeed.login.errorcode");
            session.setAttribute("org.apache.jetspeed.security.subject", (Object)subject);
            System.out.println("*** login session = " + session);
        } else {
            Principal principal;
            Subject subject = (Subject)request.getSession().getAttribute("org.apache.jetspeed.security.subject");
            if (!(subject == null || (principal = SubjectHelper.getPrincipal((Subject)subject, User.class)) != null && principal.getName().equals(this.guest))) {
                sRequest = this.wrapperRequest(request, subject, principal);
            }
        }
        sRequest.setAttribute("org.apache.jetspeed.login.filter.PortalFilter", (Object)"true");
        if (filterChain != null) {
            filterChain.doFilter(sRequest, sResponse);
        }
    }

    private ServletRequest wrapperRequest(HttpServletRequest request, Subject subject, Principal principal) {
        PortalRequestWrapper wrapper = new PortalRequestWrapper(request, subject, principal);
        return wrapper;
    }

    public void destroy() {
    }
}

