/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.ntlm;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class NtlmHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Principal principal;
    private String remoteUser;

    public NtlmHttpServletRequestWrapper(HttpServletRequest req, String ignoreNtmlUrls) {
        super(req);
        if (req instanceof HttpServletRequestWrapper) {
            Object[] urls = ignoreNtmlUrls != null ? StringUtils.split((String)ignoreNtmlUrls, (char)',') : new String[]{};
            String servletUrl = req.getServletPath();
            Principal reqPrincipal = req.getUserPrincipal();
            HttpServletRequest originalRequest = (HttpServletRequest)((HttpServletRequestWrapper)req).getRequest();
            if (originalRequest.getUserPrincipal() != null) {
                this.principal = originalRequest.getUserPrincipal();
            } else if (!ArrayUtils.contains((Object[])urls, (Object)servletUrl) && reqPrincipal != null && req.getRemoteUser() != null) {
                this.principal = reqPrincipal;
                this.remoteUser = req.getRemoteUser();
            }
        } else {
            this.principal = super.getUserPrincipal();
        }
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }
}

