/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.ntlm;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.AbstractSecurityValve;
import org.apache.jetspeed.statistics.PortalStatistics;

public class NtlmSecurityValve
extends AbstractSecurityValve {
    private UserManager userMgr;
    private PortalStatistics statistics;
    private String networkDomain;
    private boolean ntlmAuthRequired;
    private boolean omitDomain;

    public NtlmSecurityValve(UserManager userMgr, String networkDomain, boolean omitDomain, boolean ntlmAuthRequired, PortalStatistics statistics, PortalAuthenticationConfiguration authenticationConfiguration) {
        this.userMgr = userMgr;
        this.statistics = statistics;
        this.networkDomain = networkDomain;
        this.ntlmAuthRequired = ntlmAuthRequired;
        this.omitDomain = omitDomain;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public NtlmSecurityValve(UserManager userMgr, String networkDomain, boolean omitDomain, boolean ntlmAuthRequired, PortalStatistics statistics) {
        this(userMgr, networkDomain, omitDomain, ntlmAuthRequired, statistics, null);
    }

    public NtlmSecurityValve(UserManager userMgr, String networkDomain, boolean omitDomain, boolean ntlmAuthRequired) {
        this(userMgr, networkDomain, omitDomain, ntlmAuthRequired, null);
    }

    public String toString() {
        return "NtlmSecurityValve";
    }

    protected Principal getUserPrincipal(RequestContext context) throws Exception {
        Subject subject = this.getSubjectFromSession(context);
        if (subject != null) {
            return SubjectHelper.getPrincipal((Subject)subject, User.class);
        }
        return this.userMgr.newTransientUser(this.userMgr.getAnonymousUser());
    }

    protected Subject getSubject(RequestContext context) throws Exception {
        Principal subjectUserPrincipal;
        Subject subject = this.getSubjectFromSession(context);
        String userName = context.getRequest().getRemoteUser();
        if (userName == null) {
            if (this.ntlmAuthRequired) {
                throw new PipelineException("Authorization failed.");
            }
            if (context.getRequest().getUserPrincipal() != null) {
                userName = context.getRequest().getUserPrincipal().getName();
            }
        } else if (this.omitDomain && this.networkDomain != null) {
            userName = StringUtils.stripStart((String)userName, (String)(this.networkDomain + "\\"));
        }
        if (!(subject == null || (subjectUserPrincipal = SubjectHelper.getPrincipal((Subject)subject, User.class)) != null && subjectUserPrincipal.getName().equals(userName))) {
            subject = null;
        }
        if (subject == null) {
            if (userName != null) {
                try {
                    User user = this.userMgr.getUser(userName);
                    if (user != null) {
                        subject = this.userMgr.getSubject(user);
                    }
                }
                catch (SecurityException sex) {
                    subject = null;
                }
                if (subject == null && this.ntlmAuthRequired) {
                    throw new PipelineException("Authorization failed for user '" + userName + "'.");
                }
            }
            if (subject == null) {
                subject = this.userMgr.getSubject(this.userMgr.getUser(this.userMgr.getAnonymousUser()));
            }
            if (this.statistics != null) {
                this.statistics.logUserLogin(context, 0L);
            }
            context.setSessionAttribute(IP_ADDRESS, (Object)context.getRequest().getRemoteAddr());
        }
        return subject;
    }
}

