/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="data")
public class UserDetailBean
implements Serializable {
    private Map<String, String> infoMap;
    private Timestamp creationDate;
    private Timestamp modifiedDate;
    private boolean enabled = true;
    private boolean credentialUpdateRequired = false;
    private List<String> roles = null;
    private List<String> groups = null;
    private List<String> availableRoles = null;
    private List<String> availableGroups = null;
    private static final long serialVersionUID = 1L;
    private String name;

    public UserDetailBean() {
    }

    public UserDetailBean(User user, PasswordCredential credential, List<Role> roles, List<Group> groups, List<String> allRoles, List<String> allGroups) {
        this.name = user.getName();
        this.infoMap = user.getInfoMap();
        this.creationDate = user.getCreationDate();
        this.modifiedDate = user.getModifiedDate();
        this.enabled = user.isEnabled();
        this.availableRoles = allRoles;
        this.availableGroups = allGroups;
        this.credentialUpdateRequired = credential.isUpdateRequired();
        for (Role role : roles) {
            this.roles = this.roles == null ? new ArrayList() : this.roles;
            this.roles.add(role.getName());
            if (!this.availableRoles.contains(role.getName())) continue;
            this.availableRoles.remove(role.getName());
        }
        for (Group group : groups) {
            this.groups = this.groups == null ? new ArrayList() : this.groups;
            this.groups.add(group.getName());
            if (!this.availableGroups.contains(group.getName())) continue;
            this.availableGroups.remove(group.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getInfoMap() {
        return this.infoMap;
    }

    public void setInfoMap(Map<String, String> infoMap) {
        this.infoMap = infoMap;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
    }

    public Timestamp getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Timestamp modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getAvailableRoles() {
        return this.availableRoles;
    }

    public void setAvailableRoles(List<String> availableRoles) {
        this.availableRoles = availableRoles;
    }

    public List<String> getAvailableGroups() {
        return this.availableGroups;
    }

    public void setAvailableGroups(List<String> availableGroups) {
        this.availableGroups = availableGroups;
    }

    public boolean isCredentialUpdateRequired() {
        return this.credentialUpdateRequired;
    }
}

