/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.layout.PortletPlacementException;
import org.apache.jetspeed.layout.impl.CoordinateImpl;
import org.apache.jetspeed.layout.impl.PortletPlacementContextImpl;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.services.beans.ContentFragmentBean;
import org.apache.jetspeed.services.beans.ContentPageBean;
import org.apache.jetspeed.services.beans.DecorationBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/pagelayout/")
public class PageLayoutService {
    private static Logger log = LoggerFactory.getLogger(PageLayoutService.class);
    protected PageLayoutComponent pageLayoutComponent;
    protected PortletRegistry portletRegistry;
    protected PortletActionSecurityBehavior securityBehavior;
    private ContentFragmentRowComparator contentFragmentRowComparator = new ContentFragmentRowComparator();
    @Context
    private ServletConfig servletConfig;
    @Context
    private ServletContext servletContext;

    public PageLayoutService(PageLayoutComponent pageLayoutComponent, PortletRegistry portletRegistry, PortletActionSecurityBehavior securityBehavior) {
        this.pageLayoutComponent = pageLayoutComponent;
        this.portletRegistry = portletRegistry;
        this.securityBehavior = securityBehavior;
    }

    public PageLayoutService(PageLayoutComponent pageLayoutComponent, PortletRegistry portletRegistry) {
        this(pageLayoutComponent, portletRegistry, null);
    }

    @GET
    @Path(value="/page/")
    public ContentPageBean getContentPage(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.VIEW);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        return new ContentPageBean(contentPage);
    }

    @GET
    @Path(value="/fragment/{id}/")
    public ContentFragmentBean getContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="id") String fragmentId) {
        if (StringUtils.isBlank((String)fragmentId)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment id not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.VIEW);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        ContentFragment contentFragment = contentPage.getFragmentById(fragmentId);
        if (contentFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment not found with the specified id: " + fragmentId));
        }
        return new ContentFragmentBean(contentFragment);
    }

    @POST
    @Path(value="/fragment/{type}/{name}/")
    public ContentFragmentBean addContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String fragmentType, @PathParam(value="name") String fragmentName, @FormParam(value="row") String rowParam, @FormParam(value="col") String colParam, @FormParam(value="minrowscol") String minRowsColumnParam) {
        if (StringUtils.isBlank((String)fragmentType) || StringUtils.isBlank((String)fragmentName)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment type and name not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.EDIT);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        int row = NumberUtils.toInt((String)rowParam, (int)-1);
        int col = NumberUtils.toInt((String)colParam, (int)-1);
        boolean minRowsColumn = BooleanUtils.toBoolean((String)minRowsColumnParam);
        try {
            ContentFragment contentFragment = this.pageLayoutComponent.addPortlet(contentPage, fragmentType, fragmentName);
            String addedContentFragmentId = contentFragment.getId();
            ContentFragment layoutFragment = null;
            if (col == -1 && minRowsColumn) {
                layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), addedContentFragmentId);
                col = this.getMinRowsColumnIndex(layoutFragment);
            }
            if (row != -1 || col != -1) {
                this.pageLayoutComponent.updateRowColumn(contentFragment, row, col);
            }
            if (layoutFragment == null) {
                layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), addedContentFragmentId);
            }
            PortletPlacementContextImpl ppc = new PortletPlacementContextImpl(contentPage, this.portletRegistry, layoutFragment);
            contentPage = ppc.syncPageFragments();
            return new ContentFragmentBean(contentFragment);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/fragment/{id}/")
    public ContentFragmentBean deleteContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="id") String fragmentId) {
        if (StringUtils.isBlank((String)fragmentId)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment id not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.EDIT);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        ContentFragment contentFragment = contentPage.getFragmentById(fragmentId);
        if (contentFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment not found with the specified id: " + fragmentId));
        }
        ContentFragment layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), fragmentId);
        if (layoutFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found for the fragment: " + fragmentId));
        }
        try {
            this.pageLayoutComponent.removeFragment(contentPage, fragmentId);
            PortletPlacementContextImpl ppc = new PortletPlacementContextImpl(contentPage, this.portletRegistry, layoutFragment);
            contentPage = ppc.syncPageFragments();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return new ContentFragmentBean(contentFragment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="/fragment/{id}/pos/")
    public ContentFragmentBean moveContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="id") String fragmentId, @QueryParam(value="layout") String layoutFragmentId, @QueryParam(value="dir") String direction, @QueryParam(value="row") String rowParam, @QueryParam(value="col") String colParam, @QueryParam(value="x") String posXParam, @QueryParam(value="y") String posYParam, @QueryParam(value="z") String posZParam, @QueryParam(value="w") String posWidthParam, @QueryParam(value="h") String posHeightParam) {
        if (StringUtils.isBlank((String)fragmentId)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment id not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.EDIT);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        ContentFragment contentFragment = contentPage.getFragmentById(fragmentId);
        if (contentFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment not found with the specified id: " + fragmentId));
        }
        if (!StringUtils.isBlank((String)direction)) {
            direction = direction.trim();
            ContentFragment layoutFragment = null;
            if (!StringUtils.isBlank((String)layoutFragmentId)) {
                layoutFragment = contentPage.getFragmentByFragmentId(layoutFragmentId);
                if (layoutFragment == null) {
                    throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found with the specified id: " + layoutFragmentId));
                }
            } else {
                layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), fragmentId);
                if (layoutFragment == null) {
                    throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found for the fragment: " + fragmentId));
                }
            }
            PortletPlacementContextImpl ppc = null;
            try {
                ppc = new PortletPlacementContextImpl(contentPage, this.portletRegistry, layoutFragment);
                if ("left".equals(direction)) {
                    ppc.moveLeft(contentFragment);
                } else if ("right".equals(direction)) {
                    ppc.moveRight(contentFragment);
                } else if ("up".equals(direction)) {
                    ppc.moveUp(contentFragment);
                } else {
                    if (!"down".equals(direction)) throw new WebApplicationException((Throwable)new IllegalArgumentException("Invalid direction: " + direction));
                    ppc.moveDown(contentFragment);
                }
                contentPage = ppc.syncPageFragments("user", null);
                return new ContentFragmentBean(contentFragment);
            }
            catch (PortletPlacementException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        if (!StringUtils.isBlank((String)rowParam) && !StringUtils.isBlank((String)colParam)) {
            int row = NumberUtils.toInt((String)rowParam, (int)-1);
            int col = NumberUtils.toInt((String)colParam, (int)-1);
            float posHeight = NumberUtils.toFloat((String)posHeightParam, (float)-1.0f);
            if (row != -1 && col != -1 && (contentFragment.getLayoutRow() != row || contentFragment.getLayoutColumn() != col)) {
                try {
                    ContentFragment layoutFragment = null;
                    boolean attach = false;
                    if (!StringUtils.isBlank((String)layoutFragmentId) && layoutFragmentId.equals("attach")) {
                        layoutFragmentId = null;
                        attach = true;
                    }
                    if (!StringUtils.isBlank((String)layoutFragmentId)) {
                        layoutFragment = contentPage.getFragmentByFragmentId(layoutFragmentId);
                        if (layoutFragment == null) {
                            throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found with the specified id: " + layoutFragmentId));
                        }
                    } else {
                        layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), fragmentId);
                        if (layoutFragment == null) {
                            throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found for the fragment: " + fragmentId));
                        }
                    }
                    PortletPlacementContextImpl ppc = new PortletPlacementContextImpl(contentPage, this.portletRegistry, layoutFragment);
                    CoordinateImpl coordinate = new CoordinateImpl(0, 0, col, row);
                    ppc.moveAbsolute(contentFragment, coordinate);
                    if (posHeight != -1.0f) {
                        this.pageLayoutComponent.updatePosition(contentFragment, -1.0f, -1.0f, -1.0f, -1.0f, posHeight, "user", null);
                    }
                    contentPage = ppc.syncPageFragments("user", null);
                    if (!attach) return new ContentFragmentBean(contentFragment);
                    this.pageLayoutComponent.updateStateMode(contentFragment, JetspeedActions.NORMAL, null, "user", null);
                    return new ContentFragmentBean(contentFragment);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e);
                }
            } else {
                if (StringUtils.isBlank((String)layoutFragmentId) || !layoutFragmentId.equals("attach")) return new ContentFragmentBean(contentFragment);
                this.pageLayoutComponent.updateStateMode(contentFragment, JetspeedActions.NORMAL, null, "user", null);
            }
            return new ContentFragmentBean(contentFragment);
        }
        float posX = NumberUtils.toFloat((String)posXParam, (float)-1.0f);
        float posY = NumberUtils.toFloat((String)posYParam, (float)-1.0f);
        float posZ = NumberUtils.toFloat((String)posZParam, (float)-1.0f);
        float posWidth = NumberUtils.toFloat((String)posWidthParam, (float)-1.0f);
        float posHeight = NumberUtils.toFloat((String)posHeightParam, (float)-1.0f);
        try {
            this.pageLayoutComponent.updatePosition(contentFragment, posX, posY, posZ, posWidth, posHeight, "user", null);
            this.pageLayoutComponent.updateStateMode(contentFragment, JetspeedActions.DETACH, null, "user", null);
            if (layoutFragmentId == null || !layoutFragmentId.equals("detach")) return new ContentFragmentBean(contentFragment);
            ContentFragment layoutFragment = this.getParentFragment(contentPage.getNonTemplateRootFragment(), fragmentId);
            if (layoutFragment == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("Layout fragment not found for the fragment: " + fragmentId));
            }
            PortletPlacementContextImpl ppc = new PortletPlacementContextImpl(contentPage, this.portletRegistry, layoutFragment);
            int col = contentFragment.getLayoutColumn();
            int row = ppc.getNumberRows(col <= 0 ? 0 : col - 1);
            CoordinateImpl coordinate = new CoordinateImpl(col, contentFragment.getLayoutRow(), col, row);
            ppc.moveAbsolute(contentFragment, coordinate);
            contentPage = ppc.syncPageFragments("user", null);
            return new ContentFragmentBean(contentFragment);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="/fragment/{id}/mod/")
    public ContentFragmentBean modifyContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="id") String fragmentId, @QueryParam(value="state") String state, @QueryParam(value="mode") String mode) {
        if (StringUtils.isBlank((String)fragmentId)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment id not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.EDIT);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        ContentFragment contentFragment = contentPage.getFragmentById(fragmentId);
        if (contentFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment not found with the specified id: " + fragmentId));
        }
        if (!StringUtils.isBlank((String)state) || !StringUtils.isBlank((String)state)) {
            this.pageLayoutComponent.updateStateMode(contentFragment, state, mode, "user", null);
        }
        return new ContentFragmentBean(contentFragment);
    }

    @GET
    @Path(value="/decoration/fragment/{id}/")
    public DecorationBean getDecorationOfContentFragment(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="id") String fragmentId) {
        if (StringUtils.isBlank((String)fragmentId)) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment id not specified"));
        }
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage contentPage = null;
        try {
            contentPage = this.getContentPage(requestContext, JetspeedActions.VIEW);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        ContentFragment contentFragment = contentPage.getFragmentById(fragmentId);
        if (contentFragment == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Fragment not found with the specified id: " + fragmentId));
        }
        Decoration decoration = contentFragment.getDecoration();
        if (decoration == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Decoration not found with the specified id: " + fragmentId));
        }
        return new DecorationBean(decoration);
    }

    private ContentPage getContentPage(RequestContext requestContext, String action) throws SecurityException {
        if (this.securityBehavior != null && !this.securityBehavior.checkAccess(requestContext, action)) {
            throw new SecurityException("Insufficient access to view page");
        }
        return requestContext.getPage();
    }

    private ContentFragment getParentFragment(ContentFragment contentFragment, String fragmentId) {
        for (ContentFragment child : contentFragment.getFragments()) {
            ContentFragment parent;
            if (fragmentId.equals(child.getId())) {
                return contentFragment;
            }
            if (!"layout".equals(child.getType()) || (parent = this.getParentFragment(child, fragmentId)) == null) continue;
            return parent;
        }
        return null;
    }

    private int getColumnCountOfLayoutFragment(ContentFragment layoutFragment) {
        int columnCount = 1;
        String sizes = layoutFragment.getLayoutSizes();
        if (StringUtils.isBlank((String)sizes) && this.portletRegistry != null) {
            PortletDefinition layoutPortletDef = this.portletRegistry.getPortletDefinitionByUniqueName(layoutFragment.getName(), true);
            InitParam initParam = layoutPortletDef.getInitParam("sizes");
            if (initParam != null) {
                sizes = initParam.getParamValue();
            } else {
                initParam = layoutPortletDef.getInitParam("columns");
                if (initParam != null) {
                    return Integer.parseInt(initParam.getParamValue());
                }
            }
        }
        if (!StringUtils.isBlank((String)sizes)) {
            columnCount = StringUtils.splitPreserveAllTokens((String)sizes, (String)",").length;
        }
        return columnCount;
    }

    private SortedSet<ContentFragment>[] getSortedChildFragmentSetArray(ContentFragment layoutFragment, int columnCount) {
        if (columnCount <= 0) {
            throw new IllegalArgumentException("Invalid columnCount: " + columnCount);
        }
        int defaultColumn = columnCount - 1;
        TreeSet[] fragmentSetArray = new TreeSet[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            fragmentSetArray[i] = new TreeSet<ContentFragment>(this.contentFragmentRowComparator);
        }
        for (ContentFragment child : layoutFragment.getFragments()) {
            int column = child.getLayoutColumn();
            if (column < 0 || column >= columnCount) {
                column = defaultColumn;
            }
            fragmentSetArray[column].add(child);
        }
        return fragmentSetArray;
    }

    private int getMinRowsColumnIndex(ContentFragment layoutFragment) {
        int columnCount = this.getColumnCountOfLayoutFragment(layoutFragment);
        SortedSet<ContentFragment>[] fragmentSetArray = this.getSortedChildFragmentSetArray(layoutFragment, columnCount);
        int col = fragmentSetArray.length - 1;
        int rowCount = fragmentSetArray[col].size();
        for (int i = fragmentSetArray.length - 2; i >= 0; --i) {
            if (fragmentSetArray[i].size() >= rowCount) continue;
            col = i;
            rowCount = fragmentSetArray[i].size();
        }
        return col;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtendedContentFragmentRowComparator
    implements Comparator<ContentFragment> {
        private boolean movingDown;
        private ContentFragment movingFragment;

        public ExtendedContentFragmentRowComparator(boolean movingDown, ContentFragment movingFragment) {
            this.movingDown = movingDown;
            this.movingFragment = movingFragment;
        }

        @Override
        public int compare(ContentFragment f1, ContentFragment f2) {
            int r1 = f1.getLayoutRow();
            int r2 = f2.getLayoutRow();
            String s1 = f1.getState();
            String s2 = f2.getState();
            if (!StringUtils.isEmpty((String)s1) && s1.equals(JetspeedActions.DETACH)) {
                if (StringUtils.isEmpty((String)s2) || !s2.equals(JetspeedActions.DETACH)) {
                    return -1;
                }
            } else if (!StringUtils.isEmpty((String)s2) && s2.equals(JetspeedActions.DETACH) && (StringUtils.isEmpty((String)s1) || !s1.equals(JetspeedActions.DETACH))) {
                return 1;
            }
            if (r1 == r2) {
                if (f1 == this.movingFragment) {
                    return this.movingDown ? 1 : -1;
                }
                if (f2 == this.movingFragment) {
                    return this.movingDown ? -1 : 1;
                }
                return 0;
            }
            if (r1 != -1 && r2 == -1) {
                return -1;
            }
            if (r1 == -1 && r2 != -1) {
                return 1;
            }
            if (r1 > r2) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContentFragmentRowComparator
    implements Comparator<ContentFragment> {
        private ContentFragmentRowComparator() {
        }

        @Override
        public int compare(ContentFragment f1, ContentFragment f2) {
            int r1 = f1.getLayoutRow();
            int r2 = f2.getLayoutRow();
            String s1 = f1.getState();
            String s2 = f2.getState();
            if (!StringUtils.isEmpty((String)s1) && s1.equals(JetspeedActions.DETACH)) {
                if (StringUtils.isEmpty((String)s2) || !s2.equals(JetspeedActions.DETACH)) {
                    return -1;
                }
            } else if (!StringUtils.isEmpty((String)s2) && s2.equals(JetspeedActions.DETACH) && (StringUtils.isEmpty((String)s1) || !s1.equals(JetspeedActions.DETACH))) {
                return 1;
            }
            if (r1 == r2) {
                return 0;
            }
            if (r1 != -1 && r2 == -1) {
                return -1;
            }
            if (r1 == -1 && r2 != -1) {
                return 1;
            }
            if (r1 > r2) {
                return 1;
            }
            return -1;
        }
    }
}

