/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.jetspeed.services.beans.PortletApplicationBean;
import org.apache.jetspeed.services.beans.PortletApplicationBeanCollection;
import org.apache.jetspeed.services.beans.PortletDefinitionBean;
import org.apache.jetspeed.services.beans.PortletDefinitionBeanCollection;
import org.apache.jetspeed.services.rest.util.PaginationUtils;
import org.apache.jetspeed.services.rest.util.SearchEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/portletregistry/")
public class PortletRegistryService {
    private static Logger log = LoggerFactory.getLogger(PortletRegistryService.class);
    @Context
    private ServletConfig servletConfig;
    @Context
    private ServletContext servletContext;
    private SecurityAccessController securityAccessController;
    private PortletRegistry portletRegistry;
    private SearchEngine searchEngine;

    public PortletRegistryService(SecurityAccessController securityAccessController, PortletRegistry portletRegistry, SearchEngine searchEngine) {
        this.securityAccessController = securityAccessController;
        this.portletRegistry = portletRegistry;
        this.searchEngine = searchEngine;
    }

    @GET
    @Path(value="/application/{path:.*}")
    public PortletApplicationBeanCollection getPortletApplications(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="path") List<PathSegment> pathSegments, @QueryParam(value="query") String queryParam, @QueryParam(value="begin") String beginIndexParam, @QueryParam(value="max") String maxResultsParam) {
        String applicationName = null;
        if (pathSegments != null && !pathSegments.isEmpty()) {
            applicationName = pathSegments.get(0).getPath();
        }
        int beginIndex = NumberUtils.toInt((String)beginIndexParam, (int)-1);
        int maxResults = NumberUtils.toInt((String)maxResultsParam, (int)-1);
        PortletApplicationBeanCollection paBeans = new PortletApplicationBeanCollection();
        paBeans.setBeginIndex(beginIndex);
        paBeans.setTotalSize(0);
        ArrayList<PortletApplicationBean> paBeanList = new ArrayList<PortletApplicationBean>();
        if (!StringUtils.isBlank((String)queryParam)) {
            String queryText = "fieldname.type:\"portlet_application\" AND ( " + queryParam + " )";
            SearchResults searchResults = this.searchEngine.search(queryText);
            List list = searchResults.getResults();
            paBeans.setTotalSize(list.size());
            for (ParsedObject parsedObject : PaginationUtils.subList(list, beginIndex, maxResults)) {
                PortletApplication pa;
                String appName = SearchEngineUtils.getFieldAsString(parsedObject, "ID", null);
                if (StringUtils.isBlank((String)appName) || (pa = this.portletRegistry.getPortletApplication(appName)) == null) continue;
                paBeanList.add(new PortletApplicationBean(pa));
            }
        } else if (StringUtils.isBlank((String)applicationName)) {
            Collection pas = this.portletRegistry.getPortletApplications();
            paBeans.setTotalSize(pas.size());
            for (PortletApplication portletApplication : PaginationUtils.subCollection(pas, beginIndex, maxResults)) {
                paBeanList.add(new PortletApplicationBean(portletApplication));
            }
        } else {
            PortletApplication pa = this.portletRegistry.getPortletApplication(applicationName, true);
            if (pa != null) {
                paBeans.setTotalSize(1);
                paBeanList.add(new PortletApplicationBean(pa));
            }
        }
        paBeans.setApplications(paBeanList);
        return paBeans;
    }

    @GET
    @Path(value="/definition/{path:.*}")
    public PortletDefinitionBeanCollection getPortletDefinitions(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="path") List<PathSegment> pathSegments, @QueryParam(value="query") String queryParam, @QueryParam(value="begin") String beginIndexParam, @QueryParam(value="max") String maxResultsParam) {
        String applicationName = null;
        String definitionName = null;
        if (pathSegments != null) {
            if (pathSegments.size() > 0) {
                applicationName = pathSegments.get(0).getPath();
            }
            if (pathSegments.size() > 1) {
                definitionName = pathSegments.get(1).getPath();
            }
        }
        int beginIndex = NumberUtils.toInt((String)beginIndexParam, (int)-1);
        int maxResults = NumberUtils.toInt((String)maxResultsParam, (int)-1);
        PortletDefinitionBeanCollection pdBeans = new PortletDefinitionBeanCollection();
        pdBeans.setBeginIndex(beginIndex);
        pdBeans.setTotalSize(0);
        ArrayList<PortletDefinitionBean> pdBeanList = new ArrayList<PortletDefinitionBean>();
        if (!StringUtils.isBlank((String)queryParam)) {
            String queryText = "fieldname.type:\"portlet\" AND NOT fieldname.type:\"portlet_application\" AND ( " + queryParam + " )";
            SearchResults searchResults = this.searchEngine.search(queryText);
            List list = searchResults.getResults();
            ArrayList<PortletDefinition> searchedPortletDefinitions = new ArrayList<PortletDefinition>();
            for (ParsedObject parsedObject : list) {
                PortletDefinition pd;
                String string = SearchEngineUtils.getPortletUniqueName(parsedObject);
                if (StringUtils.isBlank((String)string) || (pd = this.portletRegistry.getPortletDefinitionByUniqueName(string)) == null || !this.securityAccessController.checkPortletAccess(pd, 8)) continue;
                searchedPortletDefinitions.add(pd);
            }
            Collection<PortletDefinition> filteredPortletDefinitions = this.filterPortletDefinitionsBySecurityAccess(searchedPortletDefinitions, 8, servletRequest);
            pdBeans.setTotalSize(filteredPortletDefinitions.size());
            for (PortletDefinition portletDefinition : PaginationUtils.subCollection(filteredPortletDefinitions, beginIndex, maxResults)) {
                pdBeanList.add(new PortletDefinitionBean(portletDefinition));
            }
        } else if (StringUtils.isBlank((String)applicationName) && StringUtils.isBlank((String)definitionName)) {
            Collection<PortletDefinition> pds = this.filterPortletDefinitionsBySecurityAccess(this.portletRegistry.getAllPortletDefinitions(), 8, servletRequest);
            pdBeans.setTotalSize(pds.size());
            for (PortletDefinition portletDefinition : PaginationUtils.subCollection(pds, beginIndex, maxResults)) {
                pdBeanList.add(new PortletDefinitionBean(portletDefinition));
            }
        } else {
            PortletApplication pa = this.portletRegistry.getPortletApplication(applicationName, true);
            if (pa != null) {
                if (StringUtils.isBlank((String)definitionName)) {
                    Collection<PortletDefinition> pds = this.filterPortletDefinitionsBySecurityAccess(pa.getPortlets(), 8, servletRequest);
                    pdBeans.setTotalSize(pds.size());
                    for (PortletDefinition pd : (List)PaginationUtils.subCollection(pds, beginIndex, maxResults)) {
                        pdBeanList.add(new PortletDefinitionBean(pd));
                    }
                } else {
                    PortletDefinition pd = pa.getPortlet(definitionName);
                    if (pd != null && this.securityAccessController.checkPortletAccess(pd, 8)) {
                        pdBeanList.add(new PortletDefinitionBean(pd));
                        pdBeans.setTotalSize(1);
                    }
                }
            }
        }
        pdBeans.setDefinitions(pdBeanList);
        return pdBeans;
    }

    private Collection<PortletDefinition> filterPortletDefinitionsBySecurityAccess(Collection<PortletDefinition> collection, int mask, HttpServletRequest servletRequest) {
        if (this.securityAccessController == null) {
            return collection;
        }
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PortletDefinition> filteredCollection = new ArrayList<PortletDefinition>();
        for (PortletDefinition pd : collection) {
            if (this.isFilteredOutByRole(pd, servletRequest) || !this.securityAccessController.checkPortletAccess(pd, mask)) continue;
            filteredCollection.add(pd);
        }
        return filteredCollection;
    }

    private boolean isFilteredOutByRole(PortletDefinition pd, HttpServletRequest servletRequest) {
        LocalizedField field;
        String role;
        boolean filteredOut = false;
        Collection fields = pd.getMetadata().getFields("selector.conditional.role");
        if (fields != null && !fields.isEmpty() && !StringUtils.isBlank((String)(role = (field = (LocalizedField)fields.iterator().next()).getValue()))) {
            filteredOut = role.equals("*") ? true : !servletRequest.isUserInRole(role);
        }
        return filteredOut;
    }
}

