/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.layout.PortletActionSecurityBehavior;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipalQueryContext;
import org.apache.jetspeed.security.JetspeedPrincipalResultList;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserResultList;
import org.apache.jetspeed.services.beans.UserDataTableBean;
import org.apache.jetspeed.services.beans.UserDetailBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/usermanager/")
public class UserManagerService {
    private static Logger log = LoggerFactory.getLogger(UserManagerService.class);
    private UserManager userManager;
    private RoleManager roleManager;
    private GroupManager groupManager;
    private Profiler profiler;
    private PageManager pageManager;
    private PortletActionSecurityBehavior securityBehavior;

    public UserManagerService(UserManager userManager, RoleManager roleManager, GroupManager groupManager, Profiler profiler, PageManager pageManager, PortletActionSecurityBehavior securityBehavior) {
        this.userManager = userManager;
        this.roleManager = roleManager;
        this.groupManager = groupManager;
        this.profiler = profiler;
        this.pageManager = pageManager;
        this.securityBehavior = securityBehavior;
    }

    @GET
    @Path(value="/users/")
    public UserDataTableBean findUsers(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @QueryParam(value="name") String userName, @QueryParam(value="roles") List<String> roles, @QueryParam(value="groups") List<String> groups, @QueryParam(value="start") long startIndex, @QueryParam(value="results") long results, @QueryParam(value="sort") String sortDirection, @QueryParam(value="attribute_key") List<String> attributeKeys, @QueryParam(value="attribute_value") List<String> attributeValues) {
        this.checkPrivilege(servletRequest, JetspeedActions.VIEW);
        HashMap<String, String> attributeMap = null;
        if (attributeKeys != null && attributeKeys.size() > 0 && attributeKeys.size() == attributeValues.size()) {
            attributeMap = new HashMap<String, String>();
            for (int i = 0; i < attributeKeys.size(); ++i) {
                if (attributeValues.get(i) == null || attributeValues.get(i).length() <= 0) continue;
                attributeMap.put(attributeKeys.get(i), attributeValues.get(i));
            }
        }
        JetspeedPrincipalQueryContext ctx = new JetspeedPrincipalQueryContext(userName, startIndex, results, sortDirection, roles, groups, null, attributeMap);
        try {
            UserResultList resultList = this.userManager.getUsersExtended(ctx);
            UserDataTableBean result = new UserDataTableBean((JetspeedPrincipalResultList)resultList);
            result.setStartIndex(startIndex);
            result.setPageSize(results);
            result.setRecordsReturned(results);
            return result;
        }
        catch (SecurityException e) {
            if (log.isDebugEnabled()) {
                log.error("Error searching users:" + ctx, (Throwable)e);
            } else {
                log.error("Error searching users:" + ctx + ". " + (Object)((Object)e));
            }
            return null;
        }
    }

    @GET
    @Path(value="/users/{name}/")
    public UserDetailBean getUserByName(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        this.checkPrivilege(servletRequest, JetspeedActions.VIEW);
        try {
            User user = this.userManager.getUser(userName);
            PasswordCredential credential = this.userManager.getPasswordCredential(user);
            List roles = this.roleManager.getRolesForUser(user.getName());
            List availableRoles = this.roleManager.getRoleNames(null);
            List groups = this.groupManager.getGroupsForUser(user.getName());
            List availableGroups = this.groupManager.getGroupNames(null);
            return new UserDetailBean(user, credential, roles, groups, availableRoles, availableGroups);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Error requesting users datail data:" + userName, (Throwable)e);
            }
            return null;
        }
    }

    @POST
    @Path(value="/users/{name}/")
    public Boolean updateUserDetail(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="name") String userName, @FormParam(value="user_name_given") String userNameGiven, @FormParam(value="user_name_family") String userNameFamily, @FormParam(value="user_email") String userEmail, @FormParam(value="password") String password, @FormParam(value="password_confirm") String passwordConfirm, @FormParam(value="user_enabled") Boolean userEnabled, @FormParam(value="credential_update_required") Boolean credentialUpdateRequired, @FormParam(value="roles") List<String> roles, @FormParam(value="groups") List<String> groups) {
        this.checkPrivilege(servletRequest, JetspeedActions.VIEW);
        try {
            boolean changePassword = false;
            if (password != null && password.length() > 0) {
                if (!password.equals(passwordConfirm)) {
                    Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    builder.type("text/plain");
                    builder.entity((Object)"password.confirmation.failed");
                    throw new WebApplicationException(builder.build());
                }
                changePassword = true;
            }
            User user = this.userManager.getUser(userName);
            user.getSecurityAttributes().getAttribute("user.name.given", true).setStringValue(userNameGiven);
            user.getSecurityAttributes().getAttribute("user.name.family", true).setStringValue(userNameFamily);
            user.getSecurityAttributes().getAttribute("user.email", true).setStringValue(userEmail);
            if (userEnabled == null) {
                userEnabled = false;
            }
            user.setEnabled(userEnabled.booleanValue());
            this.userManager.updateUser(user);
            if (credentialUpdateRequired == null) {
                credentialUpdateRequired = false;
            }
            PasswordCredential credential = this.userManager.getPasswordCredential(user);
            if (changePassword) {
                credential.setPassword(password, false);
            }
            credential.setUpdateRequired(credentialUpdateRequired.booleanValue());
            this.userManager.storePasswordCredential(credential);
            List currentRoles = this.roleManager.getRolesForUser(user.getName());
            for (Role currentRole : currentRoles) {
                if (roles != null && roles.contains(currentRole.getName())) {
                    roles.remove(currentRole.getName());
                    continue;
                }
                this.roleManager.removeRoleFromUser(userName, currentRole.getName());
            }
            if (roles != null) {
                for (String roleName : roles) {
                    this.roleManager.addRoleToUser(userName, roleName);
                }
            }
            List currentGroups = this.groupManager.getGroupsForUser(user.getName());
            for (Group currentGroup : currentGroups) {
                if (groups != null && groups.contains(currentGroup.getName())) {
                    groups.remove(currentGroup.getName());
                    continue;
                }
                this.groupManager.removeUserFromGroup(userName, currentGroup.getName());
            }
            if (groups != null) {
                for (String groupName : groups) {
                    this.groupManager.addUserToGroup(userName, groupName);
                }
            }
            return new Boolean(true);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (SecurityException e) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.type("text/plain");
            builder.entity((Object)e.getKeyedMessage().getKey());
            throw new WebApplicationException(builder.build());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error updating users :" + userName, (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="/users/")
    public Boolean createUser(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @FormParam(value="name") String userName, @FormParam(value="user_name_given") String userNameGiven, @FormParam(value="user_name_family") String userNameFamily, @FormParam(value="user_email") String userEmail, @FormParam(value="password") String password, @FormParam(value="password_confirm") String passwordConfirm, @FormParam(value="credential_update_required") Boolean credentialUpdateRequired) {
        this.checkPrivilege(servletRequest, JetspeedActions.VIEW);
        try {
            String[] defaultUserProfilingRules;
            String[] defaultUserRoles;
            boolean changePassword = false;
            if (password != null && password.length() > 0) {
                if (!password.equals(passwordConfirm)) {
                    Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    builder.type("text/plain");
                    builder.entity((Object)"password.confirmation.failed");
                    throw new WebApplicationException(builder.build());
                }
                changePassword = true;
            }
            User user = this.userManager.addUser(userName);
            user.getSecurityAttributes().getAttribute("user.name.given", true).setStringValue(userNameGiven);
            user.getSecurityAttributes().getAttribute("user.name.family", true).setStringValue(userNameFamily);
            user.getSecurityAttributes().getAttribute("user.email", true).setStringValue(userEmail);
            this.userManager.updateUser(user);
            if (credentialUpdateRequired == null) {
                credentialUpdateRequired = false;
            }
            PasswordCredential credential = this.userManager.getPasswordCredential(user);
            if (changePassword) {
                credential.setPassword(password, false);
            }
            credential.setUpdateRequired(credentialUpdateRequired.booleanValue());
            this.userManager.storePasswordCredential(credential);
            for (String defaultUserRole : defaultUserRoles = Jetspeed.getConfiguration().getStringArray("registration.roles.default")) {
                this.roleManager.addRoleToUser(userName, defaultUserRole);
            }
            for (String defaultUserProfilingRule : defaultUserProfilingRules = Jetspeed.getConfiguration().getStringArray("registration.roles.default")) {
                ProfilingRule profilingRule = this.profiler.getRule(defaultUserProfilingRule);
                if (profilingRule != null) {
                    this.profiler.setRuleForPrincipal((Principal)user, profilingRule, "default");
                    continue;
                }
                log.error("Failed to set profiling rule for principal. Invalid profiling rule: " + defaultUserProfilingRule);
            }
            String templateFolder = Jetspeed.getConfiguration().getString("psml.template.folder");
            if (templateFolder != null && templateFolder.trim().length() != 0) {
                Folder source = this.pageManager.getFolder(templateFolder);
                this.pageManager.deepCopyFolder(source, "/_user/" + userName, userName);
            }
            return new Boolean(true);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (SecurityException e) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.type("text/plain");
            builder.entity((Object)e.getKeyedMessage().getKey());
            throw new WebApplicationException(builder.build());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error creating users :" + userName, (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/users/{name}/")
    public Boolean deleteUserByName(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        this.checkPrivilege(servletRequest, JetspeedActions.VIEW);
        try {
            this.userManager.removeUser(userName);
            return true;
        }
        catch (SecurityException e) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.type("text/plain");
            builder.entity((Object)e.getKeyedMessage().getKey());
            throw new WebApplicationException(builder.build());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error creating users :" + userName, (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void checkPrivilege(HttpServletRequest servletRequest, String action) {
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (this.securityBehavior != null && !this.securityBehavior.checkAccess(requestContext, action)) {
            throw new WebApplicationException((Throwable)new JetspeedException("Insufficient privilege to access this REST service."));
        }
    }
}

