/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationUtils {
    private PaginationUtils() {
    }

    public static List<? extends Object> subList(List<? extends Object> list, int beginIndex, int maxResults) {
        if (beginIndex < 0 || beginIndex == 0 && maxResults < 0) {
            return list;
        }
        if (beginIndex >= list.size()) {
            return Collections.emptyList();
        }
        if (maxResults < 0) {
            return list.subList(beginIndex, list.size());
        }
        return list.subList(beginIndex, Math.min(list.size(), beginIndex + maxResults));
    }

    public static Collection<? extends Object> subCollection(Collection<? extends Object> collection, int beginIndex, int maxResults) {
        if (collection instanceof List) {
            return PaginationUtils.subList((List)collection, beginIndex, maxResults);
        }
        return PaginationUtils.subList(new ArrayList<Object>(collection), beginIndex, maxResults);
    }
}

