/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest.util;

import java.util.Collection;
import java.util.Map;
import org.apache.jetspeed.search.ParsedObject;

public class SearchEngineUtils {
    private SearchEngineUtils() {
    }

    public static Object getField(ParsedObject parsedObject, String fieldName, Object defaultValue) {
        Map fields = parsedObject.getFields();
        if (fields == null) {
            return null;
        }
        Object field = fields.get(fieldName);
        if (field == null) {
            return defaultValue;
        }
        return field;
    }

    public static String getFieldAsString(ParsedObject parsedObject, String fieldName, String defaultValue) {
        Object field = SearchEngineUtils.getField(parsedObject, fieldName, defaultValue);
        if (field instanceof Collection) {
            return (String)((Collection)field).iterator().next();
        }
        return (String)field;
    }

    public static String getPortletUniqueName(ParsedObject parsedObject) {
        if (!"portlet".equals(parsedObject.getType())) {
            return null;
        }
        String portletName = SearchEngineUtils.getFieldAsString(parsedObject, "ID", null);
        if (portletName == null) {
            return null;
        }
        String applicationName = SearchEngineUtils.getFieldAsString(parsedObject, "portlet_application", null);
        if (applicationName == null) {
            return null;
        }
        return applicationName + "::" + portletName;
    }
}

