/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.spaces;

import java.io.Serializable;
import java.util.Locale;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.spaces.SpacesServiceImpl;

public abstract class BaseSpaceImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String META_DESCRIPTION = "description";
    public static final String META_TITLE = "title";
    public static final String META_SHORT_TITLE = "short-title";
    protected transient Folder backingFolder = null;

    protected abstract String getOwnerFieldName();

    public String getName() {
        return this.backingFolder.getName();
    }

    public String getPath() {
        return this.backingFolder.getPath();
    }

    public String getOwner() {
        return SpacesServiceImpl.retrieveField(this.backingFolder, Locale.ENGLISH, this.getOwnerFieldName());
    }

    public void setOwner(String owner) {
        SpacesServiceImpl.updateField(this.backingFolder, Locale.ENGLISH, this.getOwnerFieldName(), owner);
    }

    public String getTitle() {
        return this.backingFolder.getTitle();
    }

    public void setTitle(String title) {
        this.backingFolder.setTitle(title);
    }

    public String getShortTitle() {
        return this.backingFolder.getShortTitle();
    }

    public void setShortTitle(String shortTitle) {
        this.backingFolder.setShortTitle(shortTitle);
    }

    public String getTitle(Locale locale) {
        return SpacesServiceImpl.retrieveField(this.backingFolder, locale, META_TITLE);
    }

    public void setTitle(String title, Locale locale) {
        SpacesServiceImpl.updateField(this.backingFolder, locale, META_TITLE, title);
    }

    public String getShortTitle(Locale locale) {
        return SpacesServiceImpl.retrieveField(this.backingFolder, locale, META_SHORT_TITLE);
    }

    public void setShortTitle(String shortTitle, Locale locale) {
        SpacesServiceImpl.updateField(this.backingFolder, locale, META_SHORT_TITLE, shortTitle);
    }

    public String getDescription() {
        return SpacesServiceImpl.retrieveField(this.backingFolder, null, META_DESCRIPTION);
    }

    public void setDescription(String description) {
        SpacesServiceImpl.updateField(this.backingFolder, null, META_DESCRIPTION, description);
    }

    public String getDescription(Locale locale) {
        return SpacesServiceImpl.retrieveField(this.backingFolder, locale, META_DESCRIPTION);
    }

    public void setDescription(String description, Locale locale) {
        SpacesServiceImpl.updateField(this.backingFolder, locale, META_DESCRIPTION, description);
    }

    protected Folder getBackingFolder() {
        return this.backingFolder;
    }
}

