/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.pamanager.servletcontainer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManager;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManagerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatManager
implements ApplicationServerManager {
    private static final String DEFAULT_MANAGER_APP_PATH = "/manager";
    protected static final Logger log = LoggerFactory.getLogger((String)"deployment");
    private String hostUrl;
    private int hostPort;
    private String userName;
    private String password;
    private String managerAppPath = "/manager";
    private String stopPath = this.managerAppPath + "/stop";
    private String startPath = this.managerAppPath + "/start";
    private String deployPath = this.managerAppPath + "/deploy";
    private String undeployPath = this.managerAppPath + "/undeploy";
    private HttpClient client;
    private HttpMethod start;
    private HttpMethod stop;
    private HttpMethod undeploy;
    private PutMethod deploy;

    public TomcatManager(String hostName, int hostPort, String userName, String password) throws IOException {
        this.hostUrl = hostName;
        this.hostPort = hostPort;
        this.userName = userName;
        this.password = password;
    }

    private ApplicationServerManagerResult parseResult(String responseBody) {
        if (responseBody.startsWith("OK - ")) {
            return new ApplicationServerManagerResult(true, responseBody.substring(5), responseBody);
        }
        if (responseBody.startsWith("FAIL - ")) {
            return new ApplicationServerManagerResult(false, responseBody.substring(7), responseBody);
        }
        return new ApplicationServerManagerResult(false, responseBody, responseBody);
    }

    public void start() {
        this.client = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.hostUrl, this.hostPort, "http");
        this.client.setHostConfiguration(hostConfig);
        this.client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.userName, this.password);
        this.client.getState().setCredentials(new AuthScope(this.hostUrl, this.hostPort, AuthScope.ANY_REALM), (Credentials)defaultcreds);
        this.start = new GetMethod(this.startPath);
        this.stop = new GetMethod(this.stopPath);
        this.undeploy = new GetMethod(this.undeployPath);
        this.deploy = new PutMethod(this.deployPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult start(String appPath) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.start.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.start);
            applicationServerManagerResult = this.parseResult(this.start.getResponseBodyAsString());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.start.releaseConnection();
            this.start.setPath(this.startPath);
            throw throwable;
        }
        this.start.releaseConnection();
        this.start.setPath(this.startPath);
        return applicationServerManagerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult stop(String appPath) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.stop.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.stop);
            applicationServerManagerResult = this.parseResult(this.stop.getResponseBodyAsString());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stop.releaseConnection();
            this.stop.setPath(this.stopPath);
            throw throwable;
        }
        this.stop.releaseConnection();
        this.stop.setPath(this.stopPath);
        return applicationServerManagerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult reload(String appPath) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.stop(appPath);
            Thread.sleep(1500L);
            applicationServerManagerResult = this.start(appPath);
            Object var5_4 = null;
        }
        catch (InterruptedException e) {
            ApplicationServerManagerResult applicationServerManagerResult2;
            try {
                applicationServerManagerResult2 = this.parseResult("FAIL - " + e.toString());
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.stop.releaseConnection();
                this.stop.setPath(this.stopPath);
                this.start.releaseConnection();
                this.start.setPath(this.startPath);
                throw throwable;
            }
            this.stop.releaseConnection();
            this.stop.setPath(this.stopPath);
            this.start.releaseConnection();
            this.start.setPath(this.startPath);
            return applicationServerManagerResult2;
        }
        this.stop.releaseConnection();
        this.stop.setPath(this.stopPath);
        this.start.releaseConnection();
        this.start.setPath(this.startPath);
        return applicationServerManagerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult undeploy(String appPath) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.undeploy.setQueryString(this.buildPathQueryArgs(appPath));
            this.client.executeMethod(this.undeploy);
            applicationServerManagerResult = this.parseResult(this.undeploy.getResponseBodyAsString());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.undeploy.releaseConnection();
            this.undeploy.setPath(this.undeployPath);
            throw throwable;
        }
        this.undeploy.releaseConnection();
        this.undeploy.setPath(this.undeployPath);
        return applicationServerManagerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationServerManagerResult deploy(String appPath, InputStream is, int size) throws IOException {
        ApplicationServerManagerResult applicationServerManagerResult;
        try {
            this.deploy.setQueryString(this.buildPathQueryArgs(appPath));
            this.deploy.setContentChunked(true);
            this.deploy.setRequestEntity((RequestEntity)new InputStreamRequestEntity(is));
            this.client.executeMethod((HttpMethod)this.deploy);
            applicationServerManagerResult = this.parseResult(this.deploy.getResponseBodyAsString());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.deploy.releaseConnection();
            this.deploy.setPath(this.deployPath);
            throw throwable;
        }
        this.deploy.releaseConnection();
        this.deploy.setPath(this.deployPath);
        return applicationServerManagerResult;
    }

    protected NameValuePair[] buildPathQueryArgs(String appPath) {
        if (!appPath.startsWith("/")) {
            appPath = "/" + appPath;
        }
        return new NameValuePair[]{new NameValuePair("path", appPath)};
    }

    protected NameValuePair[] buildWarQueryArgs(String warPath, String appPath) throws MalformedURLException {
        return new NameValuePair[]{new NameValuePair("war", new File(warPath).toURL().toString()), new NameValuePair("path", appPath)};
    }

    protected NameValuePair[] buildConfigQueryArgs(String configPath, String appPath) throws MalformedURLException {
        return new NameValuePair[]{new NameValuePair("config", new File(configPath).toURL().toString()), new NameValuePair("path", appPath)};
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isConnected() {
        Socket checkSocket = null;
        checkSocket = new Socket(this.hostUrl, this.hostPort);
        boolean bl = true;
        Object var5_5 = null;
        try {
            if (checkSocket != null) {
                checkSocket.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return bl;
        catch (UnknownHostException e1) {
            log.error("Unknown server: " + e1.toString());
            boolean bl2 = false;
            Object var5_6 = null;
            try {
                if (checkSocket != null) {
                    checkSocket.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl2;
        }
        catch (IOException e1) {
            log.error("IOException: " + e1.toString());
            boolean bl3 = false;
            Object var5_7 = null;
            {
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        if (checkSocket != null) {
                            checkSocket.close();
                        }
                    }
                    catch (IOException e2) {}
                    throw throwable;
                }
            }
            try {
                if (checkSocket != null) {
                    checkSocket.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl3;
        }
    }

    public void stop() {
    }

    public String getAppServerTarget(String appName) {
        return appName;
    }
}

