/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ui;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.PortletDecoration;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.headerresource.HeaderResource;
import org.apache.jetspeed.headerresource.HeaderResourceFactory;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.portlet.HeaderPhaseSupportConstants;
import org.apache.jetspeed.portlets.layout.ColumnLayout;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.ui.Toolbar;
import org.apache.jetspeed.util.HeadElementUtils;
import org.apache.jetspeed.util.KeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetui {
    private PortletRenderer renderer;
    private HeaderResourceFactory headerFactory;
    private PageLayoutComponent pageLayoutComponent;
    private PortalConfiguration pc;
    private DecorationFactory decorationFactory;
    private String layoutTemplate;

    public Jetui(PortletRenderer renderer, HeaderResourceFactory headerFactory, PageLayoutComponent pageLayoutComponent, PortalConfiguration pc, DecorationFactory decorationFactory, String layoutTemplate) {
        this.renderer = renderer;
        this.headerFactory = headerFactory;
        this.pageLayoutComponent = pageLayoutComponent;
        this.pc = pc;
        this.decorationFactory = decorationFactory;
        this.layoutTemplate = layoutTemplate;
    }

    public void process(RequestContext request, ContentFragment maximized) throws PipelineException {
        try {
            RequestDispatcher dispatcher = request.getRequest().getRequestDispatcher(this.layoutTemplate);
            request.setAttribute("jetui", (Object)this);
            ContentFragment rootFragment = request.getPage().getNonTemplateRootFragment();
            if (maximized == null) {
                String jetspeedLayout = rootFragment.getName();
                int numberOfColumns = 1;
                String layoutType = "OneColumn";
                String fragmentColumnSizes = rootFragment.getProperty("sizes");
                if (jetspeedLayout.indexOf("Two") > -1) {
                    numberOfColumns = 2;
                    layoutType = "TwoColumn";
                    if (fragmentColumnSizes == null) {
                        fragmentColumnSizes = "50%,50%";
                    }
                } else if (jetspeedLayout.indexOf("Three") > -1) {
                    numberOfColumns = 3;
                    layoutType = "ThreeColumn";
                    if (fragmentColumnSizes == null) {
                        fragmentColumnSizes = "33%,34%,33%";
                    }
                } else if (jetspeedLayout.indexOf("Four") > -1) {
                    numberOfColumns = 4;
                    layoutType = "FourColumn";
                    if (fragmentColumnSizes == null) {
                        fragmentColumnSizes = "25%,25%,25%,25%";
                    }
                } else {
                    fragmentColumnSizes = "100%";
                }
                String[] fragmentColumnSizesArray = fragmentColumnSizes.split("\\,");
                ColumnLayout columnLayout = new ColumnLayout(numberOfColumns, layoutType, (Collection)rootFragment.getFragments(), fragmentColumnSizesArray);
                columnLayout.buildDetachedPortletList((Collection)request.getPage().getRootFragment().getFragments());
                request.setAttribute("columnLayout", (Object)columnLayout);
            } else {
                ColumnLayout columnLayout = new ColumnLayout(1, "maximized", (Collection)rootFragment.getFragments(), new String[]{"100%"}, maximized);
                request.setAttribute("columnLayout", (Object)columnLayout);
            }
            dispatcher.include((ServletRequest)request.getRequest(), (ServletResponse)request.getResponse());
        }
        catch (Exception e) {
            throw new PipelineException(e.toString(), (Throwable)e);
        }
    }

    public String renderPortlet(ContentFragment fragment, RequestContext context) {
        return fragment.getRenderedContent();
    }

    public String getTitle(RequestContext context) {
        return context.getPage().getTitle(context.getLocale());
    }

    public String getBaseURL(RequestContext context) {
        StringBuffer url = new StringBuffer();
        url.append(context.getRequest().getScheme());
        url.append("://");
        url.append(context.getRequest().getServerName());
        url.append(":");
        url.append(context.getRequest().getServerPort());
        url.append(context.getRequest().getContextPath());
        url.append("/");
        return url.toString();
    }

    public Theme getTheme(RequestContext context) {
        return (Theme)context.getRequest().getAttribute("org.apache.jetspeed.theme");
    }

    public Set<String> getStyleSheets(RequestContext context) {
        return this.getStyleSheets(context, null);
    }

    public Set<String> getStyleSheets(RequestContext context, String overrideDecoratorName) {
        PortletDecoration portletDecoration;
        if (overrideDecoratorName == null) {
            return this.getTheme(context).getStyleSheets();
        }
        HashSet<String> styleSheets = new HashSet<String>();
        LayoutDecoration layoutDecoration = this.decorationFactory.getLayoutDecoration(overrideDecoratorName, context);
        if (layoutDecoration != null) {
            styleSheets.add(layoutDecoration.getStyleSheet());
            styleSheets.add(layoutDecoration.getStyleSheetPortal());
        }
        if ((portletDecoration = this.decorationFactory.getPortletDecoration(overrideDecoratorName, context)) != null) {
            styleSheets.add(portletDecoration.getStyleSheet());
            styleSheets.add(portletDecoration.getStyleSheetPortal());
        }
        return styleSheets;
    }

    public String includeHeaderResources(RequestContext context) {
        HeaderResource hr = this.headerFactory.getHeaderResouce(context);
        StringBuffer result = new StringBuffer(hr.getContent());
        List headers = context.getMergedHeadElements();
        for (KeyValue pair : headers) {
            if (HeaderPhaseSupportConstants.CONTAINER_HEAD_ELEMENT_CONTRIBUTION_ELEMENT_ID_SET.contains(pair.getKey())) continue;
            HeadElement headElement = (HeadElement)pair.getValue();
            result.append(HeadElementUtils.toHtmlString(headElement)).append('\n');
        }
        return result.toString();
    }

    public String getRenderedContent(ContentFragment fragment, RequestContext context) {
        return fragment.getRenderedContent();
    }

    public ContentFragment getContentFragment(String windowId, RequestContext context) {
        ContentPage page = context.getPage();
        return page.getFragmentByFragmentId(windowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderPortletWindow(String windowId, String portletUniqueName, RequestContext context) {
        String string;
        if (windowId == null || portletUniqueName == null) {
            throw new IllegalArgumentException("Parameter windowId and portletUniqueName are both required");
        }
        PortletWindow window = context.getPortletWindow(windowId);
        if (window == null) {
            window = context.getInstantlyCreatedPortletWindow(windowId, portletUniqueName);
        }
        if (!window.isValid()) return "";
        PortletWindow currentPortletWindow = context.getCurrentPortletWindow();
        try {
            context.setCurrentPortletWindow(window);
            this.renderer.renderNow(window.getFragment(), context);
            string = window.getFragment().getRenderedContent();
        }
        catch (Throwable throwable) {
            try {
                context.setCurrentPortletWindow(currentPortletWindow);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        context.setCurrentPortletWindow(currentPortletWindow);
        return string;
    }

    public Map<String, String> getUserAttributes(RequestContext rc) {
        Map map = null;
        Principal principal = rc.getRequest().getUserPrincipal();
        if (principal instanceof UserSubjectPrincipal) {
            UserSubjectPrincipal jp = (UserSubjectPrincipal)principal;
            map = jp.getUser().getInfoMap();
        }
        return map;
    }

    public String getUserAttribute(RequestContext rc, String attributeName, String defaultValue) {
        Map<String, String> infoMap = this.getUserAttributes(rc);
        String value = infoMap != null ? infoMap.get(attributeName) : null;
        return value != null ? value : defaultValue;
    }

    public PortalConfiguration getPortalConfiguration() {
        return this.pc;
    }

    public Toolbar getToolbar(RequestContext context, Toolbar.Orientation orientation) {
        String id;
        Toolbar toolbar = null;
        if (orientation == Toolbar.Orientation.LEFT) {
            id = "jstbLeft";
        } else if (orientation == Toolbar.Orientation.RIGHT) {
            id = "jstbRight";
        } else {
            return toolbar;
        }
        ContentPage page = context.getPage();
        ContentFragment cf = page.getFragmentByFragmentId(id);
        if (cf != null) {
            toolbar = new Toolbar(orientation, id, cf);
            toolbar.setCssClass(cf.getProperty("class"));
            String state = cf.getProperty("state");
            if (state != null) {
                toolbar.setClosed(state.equals("closed"));
            }
        }
        return toolbar;
    }

    public ContentFragment getToolbox(RequestContext context) {
        List result = context.getPage().getFragmentsByName("j2-admin::JetspeedToolbox");
        if (result != null && result.size() > 0) {
            return (ContentFragment)result.get(0);
        }
        return null;
    }

    public ContentFragment getPageNavigator(RequestContext context) {
        List result = context.getPage().getFragmentsByName("j2-admin::PageNavigator");
        if (result != null && result.size() > 0) {
            return (ContentFragment)result.get(0);
        }
        return null;
    }

    public String getPortletIcon(RequestContext context, String windowId, String defaultPortletIcon) {
        InitParam portletIconInitParam;
        String portletIcon = null;
        PortletWindow window = context.getPortletWindow(windowId);
        if (window != null && window.getPortletDefinition() != null && (portletIconInitParam = window.getPortletDefinition().getInitParam("portlet-icon")) != null) {
            portletIcon = portletIconInitParam.getParamValue();
        }
        return portletIcon != null ? portletIcon : defaultPortletIcon;
    }
}

