/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ui;

import java.io.IOException;
import org.apache.jetspeed.aggregator.PageAggregator;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.impl.AsyncPageAggregatorImpl;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.ui.Jetui;

public class JetuiAggregatorImpl
extends AsyncPageAggregatorImpl
implements PageAggregator {
    private Jetui ui;

    public JetuiAggregatorImpl(PortletRenderer renderer, Jetui ui) {
        super(renderer);
        this.ui = ui;
    }

    public void renderContent(RequestContext context, ContentFragment root) throws JetspeedException, IOException {
        ContentFragment maximized = (ContentFragment)context.getAttribute("org.apache.jetspeed.maximized.Fragment");
        this.ui.process(context, maximized);
    }

    protected void renderMaximizedWindow(RequestContext context, ContentPage page, ContentFragment layoutContentFragment, PortletWindow window) {
        PortletWindow layoutWindow;
        boolean maxedLayout = false;
        if (window.getFragment().getId().equals(layoutContentFragment.getId())) {
            layoutWindow = window;
            maxedLayout = true;
        } else {
            layoutWindow = context.getPortletWindow(layoutContentFragment);
        }
        context.setAttribute("org.apache.jetspeed.maximized.Fragment", (Object)window.getFragment());
        layoutWindow.setAttribute("org.apache.jetspeed.maximized.Layout", (Object)page.getRootFragment());
        try {
            this.renderer.renderNow(window.getFragment(), context);
            if (!maxedLayout) {
                this.renderer.renderNow(layoutContentFragment, context);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            window.getFragment().overrideRenderedContent("Sorry, but we were unable access the requested portlet. Send the following message to your portal admin:  " + e.getMessage());
        }
    }
}

