/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.ui;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;

public class JetuiPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<ContentFragment> columns = null;
    private int numberOfColumns = 1;

    public JetuiPage(ContentPage page) {
        String jetspeedLayout = page.getRootFragment().getName();
        if (jetspeedLayout.indexOf("Two") > -1) {
            this.numberOfColumns = 2;
        } else if (jetspeedLayout.indexOf("Three") > -1) {
            this.numberOfColumns = 3;
        }
        this.columns = new Vector(this.numberOfColumns);
        this.buildColumns(page.getRootFragment());
    }

    private boolean buildColumns(ContentFragment f) {
        List fragments = f.getFragments();
        if (fragments != null && !fragments.isEmpty()) {
            for (ContentFragment child : fragments) {
                boolean found = this.buildColumns(child);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    protected final int getColumn(ContentFragment fragment) {
        String propertyValue = fragment.getProperty("column");
        if (propertyValue != null) {
            int columnNumber = Integer.parseInt(propertyValue);
            if (columnNumber >= this.numberOfColumns) {
                columnNumber = this.numberOfColumns - 1;
            } else if (columnNumber < 0) {
                columnNumber = 0;
            }
            return columnNumber;
        }
        return this.numberOfColumns - 1;
    }
}

