/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.userinfo.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.jetspeed.om.portlet.UserAttribute;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.om.portlet.impl.UserAttributeRefImpl;
import org.apache.jetspeed.userinfo.UserInfoManager;
import org.apache.jetspeed.userinfo.impl.UserInfoManagerImpl;
import org.apache.pluto.container.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserInfoManagerImpl
implements UserInfoManager {
    private static final Logger log = LoggerFactory.getLogger(UserInfoManagerImpl.class);

    protected List<UserAttributeRef> mapLinkedUserAttributes(List<UserAttribute> userAttributes, List<UserAttributeRef> userAttributeRefs) {
        ArrayList<UserAttributeRef> linkedUserAttributes = new ArrayList<UserAttributeRef>();
        if (null != userAttributeRefs && userAttributeRefs.size() > 0) {
            for (UserAttribute currentAttribute : userAttributes) {
                boolean linkedAttribute = false;
                UserAttributeRefImpl impl = new UserAttributeRefImpl();
                for (UserAttributeRef currentAttributeRef : userAttributeRefs) {
                    if (!currentAttribute.getName().equals(currentAttributeRef.getNameLink())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Linking user attribute ref: [[name, " + currentAttribute.getName() + "], [linked name, " + currentAttributeRef.getName() + "]]");
                    }
                    impl.setName(currentAttributeRef.getName());
                    impl.setNameLink(currentAttributeRef.getNameLink());
                    linkedAttribute = true;
                    break;
                }
                if (!linkedAttribute) {
                    impl.setName(currentAttribute.getName());
                }
                linkedUserAttributes.add((UserAttributeRef)impl);
            }
        } else {
            for (UserAttribute currentAttribute : userAttributes) {
                UserAttributeRefImpl impl = new UserAttributeRefImpl();
                impl.setName(currentAttribute.getName());
                linkedUserAttributes.add((UserAttributeRef)impl);
            }
        }
        return linkedUserAttributes;
    }

    public Map<String, String> getUserInfo(PortletRequest request, PortletWindow window) {
        if (request.getUserPrincipal() == null) {
            return null;
        }
        org.apache.jetspeed.container.PortletWindow portletWindow = (org.apache.jetspeed.container.PortletWindow)window;
        return this.getUserInfoMap(portletWindow.getPortletDefinition().getApplication().getName(), portletWindow.getRequestContext());
    }
}

