/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.userinfo.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.userinfo.UserAttributeRetrievalException;
import org.apache.jetspeed.userinfo.UserAttributeSource;
import org.apache.jetspeed.userinfo.impl.UserInfoManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSourceUserInfoManagerImpl
extends UserInfoManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(MultiSourceUserInfoManagerImpl.class);
    private List<UserAttributeSource> sources;

    public MultiSourceUserInfoManagerImpl(PortletRegistry registry, List<UserAttributeSource> sources) {
        super(registry);
        this.sources = sources;
    }

    @Override
    public Map<String, String> getUserInfoMap(String appName, RequestContext context) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            Subject subject = context.getSubject();
            if (null != subject) {
                List<UserAttributeRef> linkedUserAttributes = this.getLinkedUserAttr(appName);
                for (UserAttributeSource source : this.sources) {
                    Map sourceMap = source.getUserAttributeMap(subject, linkedUserAttributes, context);
                    if (sourceMap == null) continue;
                    userInfoMap.putAll(sourceMap);
                }
            }
        }
        catch (UserAttributeRetrievalException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return userInfoMap;
    }
}

