/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.portlet.HeadElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadElementUtils {
    private static final int HEX = 16;
    private static final String[] KNOWN_ENTITIES = new String[]{"gt", "amp", "lt", "apos", "quot"};
    private static final Set<String> EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET = new HashSet<String>(Arrays.asList("SCRIPT", "STYLE", "TITLE"));
    private static final Set<String> PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET = new HashSet<String>(Arrays.asList("SCRIPT", "STYLE"));
    private static Logger log = LoggerFactory.getLogger(HeadElementUtils.class);

    private HeadElementUtils() {
    }

    public static String toHtmlString(HeadElement headElement) {
        String tagName = headElement.getTagName().toUpperCase();
        boolean isExpanedEmptyElements = EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        boolean isPreformattedTextContent = PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        return HeadElementUtils.toString(headElement, isExpanedEmptyElements, isPreformattedTextContent, false);
    }

    public static String toXhtmlString(HeadElement headElement) {
        String tagName = headElement.getTagName().toUpperCase();
        boolean isExpanedEmptyElements = EXPANDABLE_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        boolean isPreformattedTextContent = PREFORMATTED_HEAD_ELEMENT_TAG_NAME_SET.contains(tagName);
        return HeadElementUtils.toString(headElement, isExpanedEmptyElements, isPreformattedTextContent, true);
    }

    public static String toString(HeadElement headElement, boolean isExpanedEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA) {
        StringWriter writer = new StringWriter(80);
        try {
            HeadElementUtils.writeHeadElement(writer, headElement, isExpanedEmptyElements, isPreformattedTextContent, isPreformattedTextContentInCDATA);
        }
        catch (IOException e) {
            log.error("IOException during writing to string writer for head element. {}", (Object)e.toString());
        }
        return writer.toString();
    }

    public static void writeHeadElement(Writer writer, HeadElement headElement, boolean isExpandEmptyElements, boolean isPreformattedTextContent, boolean isPreformattedTextContentInCDATA) throws IOException {
        String tagName = headElement.getTagName();
        writer.write(60);
        writer.write(tagName);
        for (Map.Entry entry : headElement.getAttributeMap().entrySet()) {
            writer.write(32);
            writer.write((String)entry.getKey());
            writer.write("=\"");
            writer.write(HeadElementUtils.encode((String)entry.getValue()));
            writer.write("\"");
        }
        if (!headElement.hasChildHeadElements()) {
            String textContent = headElement.getTextContent();
            if (!isExpandEmptyElements && (textContent == null || "".equals(textContent))) {
                writer.write("/>");
            } else {
                writer.write(62);
                if (textContent != null) {
                    if (isPreformattedTextContent) {
                        if (isPreformattedTextContentInCDATA) {
                            writer.write("<![CDATA[");
                            writer.write(textContent);
                            writer.write("]]>");
                        } else {
                            writer.write(textContent);
                        }
                    } else {
                        writer.write(HeadElementUtils.encode(textContent));
                    }
                }
                writer.write("</");
                writer.write(tagName);
                writer.write(62);
            }
        } else {
            writer.write(">\n");
            for (HeadElement childHeadElement : headElement.getChildHeadElements()) {
                HeadElementUtils.writeHeadElement(writer, childHeadElement, isPreformattedTextContent, isExpandEmptyElements, isPreformattedTextContentInCDATA);
                writer.write(10);
            }
            writer.write("</");
            writer.write(tagName);
            writer.write(62);
        }
    }

    public static String encode(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !HeadElementUtils.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    if (!HeadElementUtils.isLegalCharacter(c)) continue block7;
                    sb.append(c);
                }
            }
        }
        return sb.substring(0);
    }

    private static boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        for (int i = 0; i < KNOWN_ENTITIES.length; ++i) {
            if (!name.equals(KNOWN_ENTITIES[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }
}

