/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.velocity;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.desktop.JetspeedDesktopContext;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.velocity.JetspeedVelocityPowerTool;
import org.apache.portals.bridges.velocity.BridgesVelocityViewServlet;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.NullSetEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.log.LogSystemCommonsLog;
import org.apache.velocity.tools.view.servlet.WebappLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedVelocityViewServlet
extends BridgesVelocityViewServlet {
    private static final Logger log = LoggerFactory.getLogger(JetspeedVelocityViewServlet.class);
    private static final long DEFAULT_CACHE_SIZE = 50L;
    private static final String CACHE_SIZE_PARAMETER = "org.apache.jetspeed.cache.size";
    private static final long DEFAULT_CACHE_VALIDATION_INTERVAL = 10000L;
    private static final String CACHE_VALIDATION_INTERVAL_PARAMETER = "org.apache.jetspeed.cache.validation.interval";
    private static ThreadLocal handlingRequestContext = new ThreadLocal();
    private TemplateLocator decorationLocator;
    private Map velocityEngineConfigCache;
    private Map velocityEngineCache;
    private long cacheValidationInterval;
    private VelocityEngine defaultVelocityEngine;
    EventCartridge eventCartridge;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ComponentManager cm = Jetspeed.getComponentManager();
        int count = 0;
        while (cm == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            cm = Jetspeed.getComponentManager();
            if (count > 5 && null == cm) {
                throw new ServletException("Could not get Jetspeed Component Manager after " + count + "tries");
            }
            ++count;
        }
        this.decorationLocator = (TemplateLocator)cm.getComponent((Object)"DecorationLocator");
        int cacheSize = (int)this.getLongInitParameter(config, CACHE_SIZE_PARAMETER, 50L);
        this.velocityEngineConfigCache = new LRUMap(cacheSize);
        this.velocityEngineCache = new LRUMap(cacheSize / 2);
        this.eventCartridge = new EventCartridge();
        this.eventCartridge.addEventHandler((EventHandler)new NullSetEventHandler(){

            public boolean shouldLogOnNullSet(String lhs, String rhs) {
                return false;
            }
        });
        this.cacheValidationInterval = this.getLongInitParameter(config, CACHE_VALIDATION_INTERVAL_PARAMETER, 10000L);
    }

    protected void initVelocity(ServletConfig config) throws ServletException {
        VelocityEngine velocity = new VelocityEngine();
        this.setVelocityEngine(velocity);
        LogSystemCommonsLog.setVelocityEngine((VelocityEngine)velocity);
        velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.tools.view.servlet.ServletLogger");
        velocity.setProperty("resource.loader", (Object)"webapp");
        velocity.setProperty("webapp.resource.loader.class", (Object)WebappLoader.class.getName());
        try {
            ExtendedProperties p = this.loadConfiguration(config);
            p.addProperty("velocimacro.library", (Object)"/WEB-INF/jetspeed_macros.vm");
            p.setProperty("file.resource.loader.path", (Object)this.getServletContext().getRealPath("/"));
            velocity.setExtendedProperties(p);
        }
        catch (Exception e) {
            this.getServletContext().log("VelocityViewServlet: Unable to read Velocity configuration file: " + e);
            this.getServletContext().log("VelocityViewServlet: Using default Velocity configuration.");
        }
        try {
            velocity.init();
        }
        catch (Exception e) {
            this.getServletContext().log("VelocityViewServlet: PANIC! unable to init() - " + e);
            throw new ServletException((Throwable)e);
        }
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        JetspeedVelocityPowerTool jpt;
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        if (requestContext == null) {
            throw new IllegalStateException("JetspeedVelocityViewServlet unable to handle request because there is no RequestContext in the HttpServletRequest.");
        }
        this.eventCartridge.attachToContext(ctx);
        JetspeedDesktopContext desktopContext = (JetspeedDesktopContext)request.getAttribute("jetspeedDesktop");
        if (desktopContext != null) {
            ctx.put("jetspeedDesktop", (Object)desktopContext);
            ctx.put("JS2RequestContext", (Object)requestContext);
            handlingRequestContext.set(ctx);
            return super.handleRequest(request, response, ctx);
        }
        PortletRequest renderRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        if (renderRequest != null) {
            renderRequest.setAttribute("org.apache.velocity.Context", (Object)ctx);
        }
        if ((jpt = (JetspeedVelocityPowerTool)renderRequest.getAttribute("org.apache.jetspeed.velocity.JetspeedPowerTool")) == null) {
            throw new IllegalStateException("JetspeedVelocityViewServlet unable to handle request because there is no JetspeedPowerTool in the HttpServletRequest.");
        }
        jpt.setVelocityContext(ctx);
        ctx.put("jetspeed", (Object)jpt);
        ctx.put("JS2RequestContext", (Object)requestContext);
        ctx.put("renderRequest", (Object)renderRequest);
        ctx.put("renderResponse", (Object)renderResponse);
        ctx.put("portletConfig", (Object)portletConfig);
        ctx.put("portletModeView", (Object)PortletMode.VIEW);
        ctx.put("portletModeEdit", (Object)PortletMode.EDIT);
        ctx.put("portletModeHelp", (Object)PortletMode.HELP);
        ctx.put("windowStateNormal", (Object)WindowState.NORMAL);
        ctx.put("windowStateMinimized", (Object)WindowState.MINIMIZED);
        ctx.put("windowStateMaximized", (Object)WindowState.MAXIMIZED);
        ctx.put("rco", (Object)requestContext.getObjects());
        StringBuffer appRoot = new StringBuffer();
        if (!requestContext.getPortalURL().isRelativeOnly()) {
            appRoot.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        }
        appRoot.append(renderRequest.getContextPath());
        ctx.put("appRoot", (Object)appRoot.toString());
        handlingRequestContext.set(ctx);
        return super.handleRequest(request, response, ctx);
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        VelocityEngine velocity;
        Context ctx = (Context)handlingRequestContext.get();
        if (ctx != null && (velocity = this.getVelocityEngine(ctx)) != null) {
            return velocity.getTemplate(name);
        }
        throw new Exception("No velocity engine available for request context.");
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        VelocityEngine velocity;
        Context ctx = (Context)handlingRequestContext.get();
        if (ctx != null && (velocity = this.getVelocityEngine(ctx)) != null) {
            return velocity.getTemplate(name, encoding);
        }
        throw new Exception("No velocity engine available for request context.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VelocityEngine getVelocityEngine(Context ctx) {
        RequestContext requestContext = (RequestContext)ctx.get("JS2RequestContext");
        JetspeedDesktopContext desktopContext = (JetspeedDesktopContext)requestContext.getRequest().getAttribute("jetspeedDesktop");
        if (desktopContext != null) {
            if (this.defaultVelocityEngine == null) {
                this.defaultVelocityEngine = this.initVelocity((TemplateDescriptor)null);
            }
            return this.defaultVelocityEngine;
        }
        RenderRequest renderRequest = (RenderRequest)ctx.get("renderRequest");
        JetspeedVelocityPowerTool jpt = (JetspeedVelocityPowerTool)ctx.get("jetspeed");
        if (renderRequest != null && requestContext != null) {
            Object object;
            ContentFragment layout = (ContentFragment)renderRequest.getAttribute("layout");
            if (layout == null) {
                layout = jpt.getCurrentFragment();
            }
            String layoutType = layout.getType();
            String layoutDecoration = layout.getDecorator();
            if (layoutDecoration == null) {
                ContentPage page = requestContext.getPage();
                layoutDecoration = page.getEffectiveDefaultDecorator(layoutType);
            }
            CapabilityMap capabilityMap = requestContext.getCapabilityMap();
            Locale locale = requestContext.getLocale();
            String layoutMediaType = capabilityMap.getPreferredMediaType().getName();
            String layoutLanguage = locale.getLanguage();
            String layoutCountry = locale.getCountry();
            String cacheKey = layoutDecoration + ":" + layoutType + ":" + layoutMediaType + ":" + layoutLanguage + ":" + layoutCountry;
            VelocityEngineConfig config = null;
            Map map = this.velocityEngineConfigCache;
            synchronized (map) {
                config = (VelocityEngineConfig)this.velocityEngineConfigCache.get(cacheKey);
            }
            long now = System.currentTimeMillis();
            if (config != null && (this.cacheValidationInterval == -1L || now <= config.lastValidated + this.cacheValidationInterval)) {
                if (config.macros != null) {
                    Map map2 = this.velocityEngineCache;
                    synchronized (map2) {
                        VelocityEngine velocity = (VelocityEngine)this.velocityEngineCache.get(config.macros.getAbsolutePath());
                        if (velocity != null) {
                            return velocity;
                        }
                    }
                } else {
                    JetspeedVelocityViewServlet jetspeedVelocityViewServlet = this;
                    synchronized (jetspeedVelocityViewServlet) {
                        if (this.defaultVelocityEngine == null) {
                            this.defaultVelocityEngine = this.initVelocity((TemplateDescriptor)null);
                        }
                        return this.defaultVelocityEngine;
                    }
                }
            }
            TemplateDescriptor macrosDescriptor = null;
            LocatorDescriptor descriptor = null;
            try {
                descriptor = this.decorationLocator.createLocatorDescriptor(null);
            }
            catch (TemplateLocatorException tle) {
                log.error("getVelocityEngine(): unable create base descriptor", (Throwable)tle);
            }
            descriptor.setMediaType(layoutMediaType);
            descriptor.setCountry(layoutCountry);
            descriptor.setLanguage(layoutLanguage);
            descriptor.setType(layoutType);
            descriptor.setName(layoutDecoration + "/" + "decorator" + ".properties");
            TemplateDescriptor propertiesDescriptor = null;
            try {
                propertiesDescriptor = this.decorationLocator.locateTemplate(descriptor);
            }
            catch (TemplateLocatorException tle) {
                try {
                    descriptor.setType("generic");
                    propertiesDescriptor = this.decorationLocator.locateTemplate(descriptor);
                }
                catch (TemplateLocatorException tleFallback) {
                    // empty catch block
                }
            }
            PropertiesConfiguration configuration = null;
            if (propertiesDescriptor != null) {
                try {
                    configuration = new PropertiesConfiguration(propertiesDescriptor.getAbsolutePath());
                }
                catch (ConfigurationException ce) {
                    log.warn("getVelocityEngine(): unable read decorator properties from " + propertiesDescriptor.getAbsolutePath(), (Throwable)ce);
                }
            }
            if (configuration != null) {
                String ext = configuration.getString("template.extension");
                String macros = configuration.getString("template.macros");
                if (ext != null && ext.length() > 0 && macros != null && macros.length() > 0) {
                    descriptor.setName(layoutDecoration + "/" + "decorator" + macros + ext);
                    try {
                        macrosDescriptor = this.decorationLocator.locateTemplate(descriptor);
                    }
                    catch (TemplateLocatorException tle) {
                        try {
                            String parent = configuration.getString("extends");
                            if (parent != null && parent.length() > 0) {
                                descriptor.setName(parent + "/" + "decorator" + macros + ext);
                                macrosDescriptor = this.decorationLocator.locateTemplate(descriptor);
                            }
                        }
                        catch (TemplateLocatorException tleExtends) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean newVelocityEngineConfig = false;
            boolean forceVelocityEngineRefresh = false;
            if (config == null) {
                config = new VelocityEngineConfig(layoutDecoration, layoutType, layoutMediaType, layoutLanguage, layoutCountry);
                Map tle = this.velocityEngineConfigCache;
                synchronized (tle) {
                    this.velocityEngineConfigCache.put(cacheKey, config);
                }
                newVelocityEngineConfig = true;
            }
            if (macrosDescriptor == null && config.macros != null || macrosDescriptor != null && config.macros == null || macrosDescriptor != null && config.macros != null && (!macrosDescriptor.getAbsolutePath().equals(config.macros.getAbsolutePath()) || config.macros.lastModified() != config.macrosLastModified)) {
                config.lastValidated = now;
                if (macrosDescriptor != null) {
                    config.macros = new File(macrosDescriptor.getAbsolutePath());
                    config.macrosLastModified = config.macros.lastModified();
                } else {
                    config.macros = null;
                    config.macrosLastModified = -1L;
                }
                forceVelocityEngineRefresh = !newVelocityEngineConfig;
            } else {
                config.lastValidated = now;
            }
            VelocityEngine velocity = null;
            if (macrosDescriptor != null && config.macros != null) {
                object = this.velocityEngineCache;
                synchronized (object) {
                    if (!forceVelocityEngineRefresh) {
                        velocity = (VelocityEngine)this.velocityEngineCache.get(config.macros.getAbsolutePath());
                    }
                    if (velocity == null && (velocity = this.initVelocity(macrosDescriptor)) != null) {
                        this.velocityEngineCache.put(config.macros.getAbsolutePath(), velocity);
                    }
                }
            }
            if (velocity == null) {
                object = this;
                synchronized (object) {
                    if (this.defaultVelocityEngine == null) {
                        this.defaultVelocityEngine = this.initVelocity((TemplateDescriptor)null);
                    }
                    velocity = this.defaultVelocityEngine;
                }
            }
            return velocity;
        }
        return null;
    }

    private VelocityEngine initVelocity(TemplateDescriptor macros) {
        try {
            VelocityEngine velocity = new VelocityEngine();
            velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
            velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.tools.view.servlet.ServletLogger");
            ExtendedProperties configuration = this.loadConfiguration(this.getServletConfig());
            if (macros != null) {
                configuration.addProperty("velocimacro.library", (Object)macros.getAppRelativePath());
            }
            configuration.setProperty("file.resource.loader.path", (Object)this.getServletContext().getRealPath("/"));
            velocity.setExtendedProperties(configuration);
            velocity.init();
            if (macros != null) {
                log.debug("initVelocity(): create new VelocityEngine instance to support " + macros.getAppRelativePath() + " decoration template macros");
            } else {
                log.debug("initVelocity(): create new default VelocityEngine instance");
            }
            return velocity;
        }
        catch (Exception e) {
            log.error("initVelocity(): unable to initialize velocity engine instance, using default singleton", (Throwable)e);
            return null;
        }
    }

    private long getLongInitParameter(ServletConfig config, String name, long defaultValue) {
        String value = config.getInitParameter(name);
        if (value == null || value.length() == 0) {
            value = config.getServletContext().getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException {
        try {
            StringBuffer html = new StringBuffer();
            html.append("<b>\n");
            html.append("Content is not available");
            html.append("<b>\n");
            this.getResponseWriter(response).write(html.toString());
            log.error("Error processing vm template ", (Throwable)e);
        }
        catch (Exception e2) {
            log.error("Error writing error message to vm template ", (Throwable)e2);
        }
    }

    private class VelocityEngineConfig {
        public String decoration;
        public String type;
        public String mediaType;
        public String language;
        public String country;
        public File macros;
        public long macrosLastModified;
        public long lastValidated;

        public VelocityEngineConfig(String decoration, String type, String mediaType, String language, String country) {
            this.decoration = decoration;
            this.type = type;
            this.mediaType = mediaType;
            this.language = language;
            this.country = country;
            this.macrosLastModified = -1L;
            this.lastValidated = System.currentTimeMillis();
        }
    }
}

