/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.PortalContext;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.request.RequestContext;

public class JetspeedPortalContext
implements PortalContext {
    private static final String SUPPORTED_WINDOWSTATE_ATTR = "supported.windowstate";
    private static final String SUPPORTED_PORTLETMODE_ATTR = "supported.portletmode";
    private static final String PORTAL_VERSION_ATTR = "portal.version";
    private static final String PORTAL_NAME_ATTR = "portal.name";
    private Engine engine = null;
    private HashMap attributes = new HashMap();
    private PortalConfiguration configuration = null;
    private String applicationRoot;
    private String contextPath;
    private String portalInfo;

    public JetspeedPortalContext() {
    }

    public JetspeedPortalContext(Engine engine, PortalConfiguration configuration, String applicationRoot) {
        this.engine = engine;
        this.configuration = configuration;
        this.applicationRoot = applicationRoot;
        this.initialize();
    }

    public PortalConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getConfigurationProperty(String key) {
        return this.configuration.getString(key);
    }

    public String getConfigurationProperty(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public void setConfiguration(PortalConfiguration configuration) {
        this.configuration = configuration;
        this.initialize();
    }

    protected void initialize() {
        this.portalInfo = this.configuration.getString(PORTAL_NAME_ATTR) + "/" + this.configuration.getString(PORTAL_VERSION_ATTR);
        String[] supportedModes = this.configuration.getStringArray(SUPPORTED_PORTLETMODE_ATTR);
        String[] supportedStates = this.configuration.getStringArray(SUPPORTED_WINDOWSTATE_ATTR);
        new JetspeedActions(supportedModes, supportedStates);
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return this.configuration.getString(name);
    }

    public Enumeration getPropertyNames() {
        final Iterator keys = this.configuration.getKeys();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return keys.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)keys.next();
            }
        };
    }

    private Collection getSupportedModes() {
        PortletWindow window;
        RequestContext rc = Jetspeed.getCurrentRequestContext();
        if (rc != null && (window = rc.getCurrentPortletWindow()) != null) {
            return window.getPortletDefinition().getApplication().getSupportedPortletModes();
        }
        return JetspeedActions.getStandardPortletModes();
    }

    public Enumeration getSupportedPortletModes() {
        return Collections.enumeration(this.getSupportedModes());
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.getSupportedModes().contains(mode);
    }

    private Collection getSupportedStates() {
        PortletWindow window;
        RequestContext rc = Jetspeed.getCurrentRequestContext();
        if (rc != null && (window = rc.getCurrentPortletWindow()) != null) {
            return window.getPortletDefinition().getApplication().getSupportedWindowStates();
        }
        return JetspeedActions.getStandardWindowStates();
    }

    public Enumeration getSupportedWindowStates() {
        return Collections.enumeration(this.getSupportedStates());
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.getSupportedStates().contains(state);
    }

    public String getPortalInfo() {
        return this.portalInfo;
    }
}

