/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.administration;

import java.util.ArrayList;
import org.apache.jetspeed.administration.PasswordGenerator;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.SecurityException;
import org.apache.taglibs.random.RandomStrg;

public class SimplePasswordGeneratorImpl
implements PasswordGenerator {
    protected static final char[] DEFAULT_PASS_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    protected char[] passwordChars = DEFAULT_PASS_CHARS;
    protected ArrayList<Character> upper = new ArrayList();
    protected ArrayList<Character> lower = new ArrayList();
    protected Integer length = new Integer(12);
    protected CredentialPasswordValidator validator;

    protected RandomStrg newRandomStrg() {
        RandomStrg rs = new RandomStrg();
        try {
            rs.generateRandomObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    protected void initRandomStrg(RandomStrg rs) {
        rs.setLength(new Integer(12));
        rs.setSingle(this.passwordChars, this.passwordChars.length);
        rs.setRanges(this.upper, this.lower);
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setValidator(CredentialPasswordValidator validator) {
        this.validator = validator;
    }

    public void setPasswordChars(String passwordChars) {
        if (passwordChars != null && passwordChars.length() > 1) {
            this.passwordChars = passwordChars.toCharArray();
        }
    }

    public void setLowerRange(String lowerChars) {
        if (lowerChars != null) {
            this.lower.clear();
            for (char c : lowerChars.toCharArray()) {
                this.lower.add(new Character(c));
            }
        }
    }

    public void setUpperRange(String upperChars) {
        if (upperChars != null) {
            this.upper.clear();
            for (char c : upperChars.toCharArray()) {
                this.upper.add(new Character(c));
            }
        }
    }

    public String generatePassword() {
        String retval = null;
        RandomStrg rs = this.newRandomStrg();
        this.initRandomStrg(rs);
        while (retval == null) {
            retval = rs.getRandom();
            if (this.validator == null) continue;
            try {
                this.validator.validate(retval);
            }
            catch (SecurityException sex) {
                retval = null;
            }
        }
        return retval;
    }
}

