/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.RenderingJob;
import org.apache.jetspeed.aggregator.Worker;
import org.apache.jetspeed.aggregator.WorkerMonitor;
import org.apache.jetspeed.container.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonjWorkerMonitorImpl
implements WorkerMonitor,
WorkListener {
    public static final String ACCESS_CONTROL_CONTEXT_WORKER_ATTR = AccessControlContext.class.getName();
    public static final String COMMONJ_WORK_ITEM_ATTR = WorkItem.class.getName();
    public static final String WORKER_THREAD_ATTR = Worker.class.getName();
    protected WorkManager workManager;
    protected boolean interruptOnTimeout = true;
    protected boolean jobWorksMonitorEnabled = true;
    protected Map<WorkItem, RenderingJobCommonjWork> jobWorksMonitored = Collections.synchronizedMap(new HashMap());
    protected static final Logger log = LoggerFactory.getLogger(CommonjWorkerMonitorImpl.class);
    protected CommonjWorkerRenderingJobTimeoutMonitor jobMonitor = null;

    public CommonjWorkerMonitorImpl(WorkManager workManager) {
        this(workManager, true);
    }

    public CommonjWorkerMonitorImpl(WorkManager workManager, boolean jobWorksMonitorEnabled) {
        this(workManager, jobWorksMonitorEnabled, true);
    }

    public CommonjWorkerMonitorImpl(WorkManager workManager, boolean jobWorksMonitorEnabled, boolean interruptOnTimeout) {
        this.workManager = workManager;
        this.jobWorksMonitorEnabled = jobWorksMonitorEnabled;
        this.interruptOnTimeout = interruptOnTimeout;
    }

    public void start() {
        if (this.jobWorksMonitorEnabled) {
            this.jobMonitor = new CommonjWorkerRenderingJobTimeoutMonitor(1000L);
            this.jobMonitor.start();
        }
    }

    public void stop() {
        if (this.jobMonitor != null) {
            this.jobMonitor.endThread();
        }
        this.jobMonitor = null;
    }

    public void process(RenderingJob job) {
        AccessControlContext context = AccessController.getContext();
        job.setWorkerAttribute(ACCESS_CONTROL_CONTEXT_WORKER_ATTR, (Object)context);
        try {
            RenderingJobCommonjWork jobWork = new RenderingJobCommonjWork(job);
            WorkItem workItem = this.workManager.schedule((Work)jobWork, (WorkListener)this);
            job.setWorkerAttribute(COMMONJ_WORK_ITEM_ATTR, (Object)workItem);
            if (this.jobWorksMonitorEnabled) {
                this.jobWorksMonitored.put(workItem, jobWork);
            }
        }
        catch (Throwable t) {
            log.error("Worker exception", t);
        }
    }

    public int getQueuedJobsCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForRenderingJobs(List<RenderingJob> renderingJobs) {
        if (this.jobWorksMonitorEnabled) {
            try {
                Iterator<RenderingJob> i$ = renderingJobs.iterator();
                while (i$.hasNext()) {
                    PortletContent portletContent;
                    RenderingJob job = i$.next();
                    PortletContent portletContent2 = portletContent = job.getPortletContent();
                    synchronized (portletContent2) {
                        if (!portletContent.isComplete()) {
                            portletContent.wait();
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                log.error("Exception during synchronizing all portlet rendering jobs.", (Throwable)e);
                return;
            }
        }
        try {
            if (renderingJobs.isEmpty()) return;
            Object lock = new Object();
            MonitoringJobCommonjWork monitoringWork = new MonitoringJobCommonjWork(lock, renderingJobs);
            Object object = lock;
            synchronized (object) {
                this.workManager.schedule((Work)monitoringWork, (WorkListener)this);
                lock.wait();
                return;
            }
        }
        catch (Exception e) {
            log.error("Exception during synchronizing all portlet rendering jobs.", (Throwable)e);
        }
    }

    public int getAvailableJobsCount() {
        return 0;
    }

    public int getRunningJobsCount() {
        return 0;
    }

    public void workAccepted(WorkEvent we) {
        WorkItem workItem = we.getWorkItem();
        if (log.isDebugEnabled()) {
            log.debug("[CommonjWorkMonitorImpl] workAccepted: " + workItem);
        }
    }

    public void workRejected(WorkEvent we) {
        WorkItem workItem = we.getWorkItem();
        if (log.isDebugEnabled()) {
            log.debug("[CommonjWorkMonitorImpl] workRejected: " + workItem);
        }
        if (this.jobWorksMonitorEnabled) {
            this.removeMonitoredJobWork(workItem);
        }
    }

    public void workStarted(WorkEvent we) {
        WorkItem workItem = we.getWorkItem();
        if (log.isDebugEnabled()) {
            log.debug("[CommonjWorkMonitorImpl] workStarted: " + workItem);
        }
    }

    public void workCompleted(WorkEvent we) {
        WorkItem workItem = we.getWorkItem();
        if (log.isDebugEnabled()) {
            log.debug("[CommonjWorkMonitorImpl] workCompleted: " + workItem);
        }
        if (this.jobWorksMonitorEnabled) {
            this.removeMonitoredJobWork(workItem);
        }
    }

    protected Object removeMonitoredJobWork(WorkItem workItem) {
        return this.jobWorksMonitored.remove(workItem);
    }

    class CommonjWorkerRenderingJobTimeoutMonitor
    extends Thread {
        long interval;
        boolean shouldRun;

        CommonjWorkerRenderingJobTimeoutMonitor(long interval) {
            super("CommonjWorkerRenderingJobTimeoutMonitor");
            this.interval = 1000L;
            this.shouldRun = true;
            this.setDaemon(true);
            if (interval > 0L) {
                this.interval = interval;
            }
        }

        public void endThread() {
            this.shouldRun = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    RenderingJob job;
                    ArrayList<RenderingJobCommonjWork> timeoutJobWorks = new ArrayList<RenderingJobCommonjWork>();
                    for (RenderingJobCommonjWork jobWork : CommonjWorkerMonitorImpl.this.jobWorksMonitored.values()) {
                        job = jobWork.getRenderingJob();
                        if (!job.isTimeout()) continue;
                        timeoutJobWorks.add(jobWork);
                    }
                    for (RenderingJobCommonjWork jobWork : timeoutJobWorks) {
                        job = jobWork.getRenderingJob();
                        if (!job.isTimeout()) continue;
                        this.killJobWork(jobWork);
                    }
                }
                catch (Exception e) {
                    log.error("Exception during job monitoring.", (Throwable)e);
                }
                try {
                    CommonjWorkerRenderingJobTimeoutMonitor e = this;
                    synchronized (e) {
                        this.wait(this.interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void killJobWork(RenderingJobCommonjWork jobWork) {
            RenderingJob job = jobWork.getRenderingJob();
            try {
                block8: {
                    try {
                        if (log.isWarnEnabled()) {
                            PortletWindow window = job.getWindow();
                            log.warn("Portlet Rendering job to be interrupted by timeout (" + job.getTimeout() + "ms)" + (window != null ? ": " + window.getId().getStringId() : ""));
                        }
                        PortletContent content = job.getPortletContent();
                        Thread worker = (Thread)job.getWorkerAttribute(WORKER_THREAD_ATTR);
                        if (worker == null) break block8;
                        PortletContent portletContent = content;
                        synchronized (portletContent) {
                            if (!content.isComplete()) {
                                worker.interrupt();
                                content.wait();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Exceptiong during job killing.", (Throwable)e);
                        Object var8_8 = null;
                        WorkItem workItem = (WorkItem)job.getWorkerAttribute(COMMONJ_WORK_ITEM_ATTR);
                        if (workItem == null) return;
                        CommonjWorkerMonitorImpl.this.removeMonitoredJobWork(workItem);
                        return;
                    }
                    {
                    }
                }
                Object var8_7 = null;
                WorkItem workItem = (WorkItem)job.getWorkerAttribute(COMMONJ_WORK_ITEM_ATTR);
                if (workItem == null) return;
                CommonjWorkerMonitorImpl.this.removeMonitoredJobWork(workItem);
                return;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                WorkItem workItem = (WorkItem)job.getWorkerAttribute(COMMONJ_WORK_ITEM_ATTR);
                if (workItem == null) throw throwable;
                CommonjWorkerMonitorImpl.this.removeMonitoredJobWork(workItem);
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MonitoringJobCommonjWork
    implements Work {
        protected Object lock;
        protected List<RenderingJob> renderingJobs;

        public MonitoringJobCommonjWork(Object lock, List<RenderingJob> jobs) {
            this.lock = lock;
            this.renderingJobs = new ArrayList<RenderingJob>(jobs);
        }

        public boolean isDaemon() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object it;
                while (!this.renderingJobs.isEmpty()) {
                    it = this.renderingJobs.iterator();
                    while (it.hasNext()) {
                        boolean isTimeout;
                        RenderingJob job = (RenderingJob)it.next();
                        WorkItem workItem = (WorkItem)job.getWorkerAttribute(COMMONJ_WORK_ITEM_ATTR);
                        int status = 1;
                        if (workItem != null) {
                            status = workItem.getStatus();
                        }
                        if (isTimeout = job.isTimeout()) {
                            PortletContent content = job.getPortletContent();
                            if (CommonjWorkerMonitorImpl.this.interruptOnTimeout) {
                                Thread worker = (Thread)job.getWorkerAttribute(WORKER_THREAD_ATTR);
                                if (worker != null) {
                                    PortletContent portletContent = content;
                                    synchronized (portletContent) {
                                        if (!content.isComplete()) {
                                            worker.interrupt();
                                            content.wait();
                                        }
                                    }
                                }
                            } else {
                                PortletContent portletContent = content;
                                synchronized (portletContent) {
                                    content.complete();
                                }
                            }
                        }
                        if (status != 4 && status != 2 && !isTimeout) continue;
                        it.remove();
                    }
                    if (this.renderingJobs.isEmpty()) continue;
                    it = this;
                    synchronized (it) {
                        this.wait(100L);
                    }
                }
                it = this.lock;
                synchronized (it) {
                    this.lock.notify();
                }
            }
            catch (Exception e) {
                log.error("Exceptiong during job timeout monitoring.", (Throwable)e);
            }
        }

        public void release() {
        }
    }

    class RenderingJobCommonjWork
    implements Work {
        protected RenderingJob job;

        public RenderingJobCommonjWork(RenderingJob job) {
            this.job = job;
        }

        public boolean isDaemon() {
            return false;
        }

        public void run() {
            if (CommonjWorkerMonitorImpl.this.jobWorksMonitorEnabled || CommonjWorkerMonitorImpl.this.interruptOnTimeout) {
                this.job.setWorkerAttribute(WORKER_THREAD_ATTR, (Object)Thread.currentThread());
            }
            this.job.run();
        }

        public void release() {
        }

        public RenderingJob getRenderingJob() {
            return this.job;
        }
    }
}

