/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.aggregator.PageAggregator;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.headerresource.HeaderResourceFactory;
import org.apache.jetspeed.headerresource.HeaderResourceLib;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderAggregatorImpl
implements PageAggregator {
    protected static final Logger log = LoggerFactory.getLogger(HeaderAggregatorImpl.class);
    protected static final String EOL = "\r\n";
    private PortletFactory factory;
    private HeaderResourceFactory headerResourceFactory;
    private DecorationFactory decorationFactory;
    private boolean isDesktop;
    private Map headerConfiguration;
    private Map headerResourceRegistry;
    private Map headerDynamicConfigurationDefault;
    private Map headerNamedResourcesDefault;
    private Map headerNamedResourcesAddedFragmentsDefault;
    private BasePortalURL baseUrlAccess = null;

    public HeaderAggregatorImpl(PortletFactory factory, HeaderResourceFactory headerResourceFactory, boolean isDesktop, Map headerConfiguration, Map headerResourceRegistry, DecorationFactory decorationFactory) {
        this(factory, headerResourceFactory, isDesktop, headerConfiguration, headerResourceRegistry, decorationFactory, null);
    }

    public HeaderAggregatorImpl(PortletFactory factory, HeaderResourceFactory headerResourceFactory, boolean isDesktop, Map headerConfiguration, Map headerResourceRegistry, DecorationFactory decorationFactory, BasePortalURL baseUrlAccess) {
        this.factory = factory;
        this.headerResourceFactory = headerResourceFactory;
        this.isDesktop = isDesktop;
        this.baseUrlAccess = baseUrlAccess;
        this.decorationFactory = decorationFactory;
        this.initializeHeaderConfiguration(headerConfiguration, headerResourceRegistry);
    }

    private void initializeHeaderConfiguration(Map headerConfigArg, Map headerRsrcRegistryArg) {
        this.headerConfiguration = null;
        this.headerResourceRegistry = null;
        this.headerDynamicConfigurationDefault = null;
        this.headerNamedResourcesDefault = null;
        this.headerNamedResourcesAddedFragmentsDefault = null;
        if (headerConfigArg != null && headerConfigArg.size() > 0) {
            HashMap headerConfig = new HashMap();
            for (Map.Entry headerConfigEntry : headerConfigArg.entrySet()) {
                Object headerConfigKey = headerConfigEntry.getKey();
                Object headerConfigVal = headerConfigEntry.getValue();
                if (headerConfigVal instanceof Map) {
                    headerConfig.put(headerConfigKey, Collections.unmodifiableMap(new HashMap((Map)headerConfigVal)));
                    continue;
                }
                if (headerConfigVal instanceof List) {
                    headerConfig.put(headerConfigKey, Collections.unmodifiableList(new ArrayList((List)headerConfigVal)));
                    continue;
                }
                headerConfig.put(headerConfigKey, headerConfigVal);
            }
            this.headerConfiguration = Collections.unmodifiableMap(headerConfig);
            HashMap headerRsrcRegistry = null;
            headerRsrcRegistry = headerRsrcRegistryArg != null && headerRsrcRegistryArg.size() > 0 ? new HashMap(headerRsrcRegistryArg) : new HashMap();
            this.headerResourceRegistry = headerRsrcRegistry;
            HashMap namedResourcesDefault = new HashMap();
            HashMap namedResourcesAddedFragmentsDefault = new HashMap();
            Map dynamicConfigurationDefault = this.initializeHeaderConfigurationDefaults(namedResourcesDefault, namedResourcesAddedFragmentsDefault);
            if (dynamicConfigurationDefault != null) {
                this.headerDynamicConfigurationDefault = Collections.unmodifiableMap(dynamicConfigurationDefault);
            }
            this.headerNamedResourcesDefault = Collections.unmodifiableMap(namedResourcesDefault);
            this.headerNamedResourcesAddedFragmentsDefault = Collections.unmodifiableMap(namedResourcesAddedFragmentsDefault);
            this.headerResourceRegistry = null;
            if (headerRsrcRegistry != null && headerRsrcRegistry.size() > 0) {
                this.headerResourceRegistry = Collections.unmodifiableMap(headerRsrcRegistry);
            }
        }
    }

    protected Map initializeHeaderConfigurationDefaults(HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault) {
        if (this.headerConfiguration == null) {
            return null;
        }
        HashMap headerDynamicConfigurationDefault = new HashMap();
        this.initializeHeaderOrderConfigurationDefaults(namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
        this.setNamedHeaderResourceProperties("header.basetag", "base-tag", null, headerDynamicConfigurationDefault);
        for (Map.Entry hConfigEntry : this.headerConfiguration.entrySet()) {
            Object hConfigVal;
            Object hConfigKey = hConfigEntry.getKey();
            if (this.initializeHeaderConfigurationEntryDefaults(hConfigKey, hConfigVal = hConfigEntry.getValue(), namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault)) continue;
            if (hConfigVal instanceof Map) {
                headerDynamicConfigurationDefault.put(hConfigKey, Collections.unmodifiableMap(new HashMap((Map)hConfigVal)));
                continue;
            }
            if (hConfigVal instanceof List) {
                headerDynamicConfigurationDefault.put(hConfigKey, Collections.unmodifiableList(new ArrayList((List)hConfigVal)));
                continue;
            }
            headerDynamicConfigurationDefault.put(hConfigKey, hConfigVal);
        }
        this.initializeMissingHeaderConfigurationEntryDefaults(namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
        this.postinitializeHeaderOrderConfigurationDefaults(headerDynamicConfigurationDefault);
        return headerDynamicConfigurationDefault;
    }

    protected void initializeHeaderOrderConfigurationDefaults(HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault, HashMap headerDynamicConfigurationDefault) {
        if (this.headerConfiguration != null) {
            Map headerRequiredFlagConfig;
            List headerOrderConfigList = (List)this.headerConfiguration.get("header.order");
            if (headerOrderConfigList != null && headerOrderConfigList.size() > 0) {
                ArrayList<String> headerOrderList = new ArrayList<String>();
                HashMap<String, Boolean> headerNames = new HashMap<String, Boolean>();
                for (Object headerNameObj : headerOrderConfigList) {
                    String headerName;
                    if (headerNameObj == null || (headerName = headerNameObj.toString()) == null || headerName.length() <= 0) continue;
                    headerOrderList.add(headerName);
                    headerNames.put(headerName, Boolean.TRUE);
                }
                headerDynamicConfigurationDefault.put("header.order", headerOrderList);
                headerDynamicConfigurationDefault.put("header.internal.names", headerNames);
            }
            HashMap<String, Object[]> headerTypes = null;
            Map headerTypesConfig = (Map)this.headerConfiguration.get("header.types");
            if (headerTypesConfig != null && headerTypesConfig.size() > 0) {
                headerTypes = new HashMap<String, Object[]>();
                for (Map.Entry headerTypeEntry : headerTypesConfig.entrySet()) {
                    Object headerNameObj = headerTypeEntry.getKey();
                    Object headerTypeObj = headerTypeEntry.getValue();
                    if (headerNameObj == null || headerTypeObj == null) continue;
                    String headerName = headerNameObj.toString();
                    int headerTypeId = HeaderResourceLib.getHeaderTypeId((String)headerTypeObj.toString());
                    if (headerName == null) continue;
                    if (headerTypeId >= 0) {
                        headerTypes.put(headerName, new Object[]{new Integer(headerTypeId), null});
                        continue;
                    }
                    log.error("HeaderAggregatorImpl.initializeHeaderOrderConfigurationDefaults() ignoring specification of unknown header section type; header-section-name=" + headerName + " header-section-type=" + headerTypeObj.toString());
                }
            }
            if ((headerRequiredFlagConfig = (Map)this.headerConfiguration.get("header.requiredflag")) != null && headerRequiredFlagConfig.size() > 0) {
                if (headerTypes == null) {
                    headerTypes = new HashMap();
                }
                for (Map.Entry headerRequiredFlagEntry : headerRequiredFlagConfig.entrySet()) {
                    Object headerNameObj = headerRequiredFlagEntry.getKey();
                    Object headerReqFlagObj = headerRequiredFlagEntry.getValue();
                    if (headerNameObj == null || headerReqFlagObj == null) continue;
                    String headerName = headerNameObj.toString();
                    String headerReqFlag = headerReqFlagObj.toString();
                    if (headerName == null || headerName.length() <= 0 || headerReqFlag == null) continue;
                    Object[] headerTypePair = (Object[])headerTypes.get(headerName);
                    if (headerTypePair != null) {
                        headerTypePair[1] = headerReqFlag;
                        continue;
                    }
                    headerTypePair = new Object[]{null, headerReqFlag};
                    headerTypes.put(headerName, headerTypePair);
                }
            }
            if (headerTypes != null && headerTypes.size() > 0) {
                headerDynamicConfigurationDefault.put("header.types", headerTypes);
            }
        }
    }

    protected void postinitializeHeaderOrderConfigurationDefaults(HashMap headerDynamicConfigurationDefault) {
        if (headerDynamicConfigurationDefault != null) {
            List headerOrderList;
            Map headerTypes;
            Map headerNames = (Map)headerDynamicConfigurationDefault.get("header.internal.names");
            if (headerNames != null) {
                headerDynamicConfigurationDefault.put("header.internal.names", Collections.unmodifiableMap(headerNames));
            }
            if ((headerTypes = (Map)headerDynamicConfigurationDefault.get("header.types")) != null) {
                headerDynamicConfigurationDefault.put("header.types", Collections.unmodifiableMap(headerTypes));
            }
            if ((headerOrderList = (List)headerDynamicConfigurationDefault.get("header.order")) != null) {
                headerDynamicConfigurationDefault.put("header.order", Collections.unmodifiableList(headerOrderList));
            }
        }
    }

    protected boolean initializeHeaderConfigurationEntryDefaults(Object headerConfigKey, Object headerConfigValue, HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault, HashMap headerDynamicConfigurationDefault) {
        if (headerConfigKey.equals("header.order") || headerConfigKey.equals("header.types") || headerConfigKey.equals("header.requiredflag")) {
            return true;
        }
        if (headerConfigKey.equals("dojo")) {
            this.initializeDojoHeaderConfigurationDefaults((Map)headerConfigValue, namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
            return true;
        }
        if (headerConfigKey.equals("desktop")) {
            this.initializeDesktopHeaderConfigurationDefaults((Map)headerConfigValue, namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
            return true;
        }
        return false;
    }

    protected void initializeMissingHeaderConfigurationEntryDefaults(HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault, HashMap headerDynamicConfigurationDefault) {
        if (this.isDesktop()) {
            if (this.headerConfiguration.get("dojo") == null) {
                this.initializeDojoHeaderConfigurationDefaults(null, namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
            }
            if (this.headerConfiguration.get("desktop") == null) {
                this.initializeDesktopHeaderConfigurationDefaults(null, namedResourcesDefault, namedResourcesAddedFragmentsDefault, headerDynamicConfigurationDefault);
            }
        }
    }

    protected void registerAndOrderNamedHeaderResource(String headerName, String headerType, String headerReqFlag, Map headerDynamicConfigurationDefault) {
        this.orderNamedHeaderResource(headerName, headerDynamicConfigurationDefault);
        this.setNamedHeaderResourceProperties(headerName, headerType, headerReqFlag, headerDynamicConfigurationDefault);
    }

    protected void orderNamedHeaderResource(String headerName, Map headerDynamicConfigurationDefault) {
        if (headerName != null) {
            Object headerNamesVal;
            HashMap<String, Boolean> headerNames = (HashMap<String, Boolean>)headerDynamicConfigurationDefault.get("header.internal.names");
            if (headerNames == null) {
                headerNames = new HashMap<String, Boolean>();
                headerDynamicConfigurationDefault.put("header.internal.names", headerNames);
            }
            if ((headerNamesVal = headerNames.get(headerName)) == null) {
                ArrayList<String> headerOrderList = (ArrayList<String>)headerDynamicConfigurationDefault.get("header.order");
                if (headerOrderList == null) {
                    headerOrderList = new ArrayList<String>();
                    headerDynamicConfigurationDefault.put("header.order", headerOrderList);
                }
                headerOrderList.add(headerName);
                headerNames.put(headerName, Boolean.TRUE);
            }
        }
    }

    protected void setNamedHeaderResourceProperties(String headerName, String headerType, String headerReqFlag, Map headerDynamicConfigurationDefault) {
        if (headerName != null) {
            boolean headerRefFlagSpecified;
            int headerTypeId = HeaderResourceLib.getHeaderTypeId((String)headerType);
            boolean bl = headerRefFlagSpecified = headerReqFlag != null && headerReqFlag.length() > 0;
            if (headerTypeId < 0 && !headerRefFlagSpecified) {
                log.error("HeaderAggregatorImpl.registerAndOrderNamedHeaderResource() ignoring specification of unknown header section type; header-section-name=" + headerName + " header-section-type=" + headerType);
            }
            if (headerTypeId >= 0 || headerRefFlagSpecified) {
                Object[] headerTypePair;
                HashMap<String, Object[]> headerTypes = (HashMap<String, Object[]>)headerDynamicConfigurationDefault.get("header.types");
                if (headerTypes == null) {
                    headerTypes = new HashMap<String, Object[]>();
                    headerDynamicConfigurationDefault.put("header.types", headerTypes);
                }
                if ((headerTypePair = (Object[])headerTypes.get(headerName)) == null) {
                    headerTypePair = new Object[]{null, null};
                    headerTypes.put(headerName, headerTypePair);
                }
                if (headerTypePair[0] == null && headerTypeId >= 0) {
                    headerTypePair[0] = new Integer(headerTypeId);
                }
                if (headerTypePair[1] == null && headerReqFlag != null && headerReqFlag.length() > 0) {
                    headerTypePair[1] = headerReqFlag;
                }
            }
        }
    }

    protected boolean canAddHeaderNamedResourceFragment(String headerFragmentName, HashMap namedResourcesAddedFragmentsDefault, String[] registryContent) {
        if (headerFragmentName != null && !namedResourcesAddedFragmentsDefault.containsKey(headerFragmentName)) {
            namedResourcesAddedFragmentsDefault.put(headerFragmentName, Boolean.TRUE);
            if (registryContent != null) {
                String registryContentVal;
                registryContent[0] = registryContentVal = (String)this.headerResourceRegistry.get(headerFragmentName);
                if (registryContentVal != null) {
                    this.headerResourceRegistry.remove(headerFragmentName);
                }
            }
            return true;
        }
        if (registryContent != null) {
            registryContent[0] = null;
        }
        return false;
    }

    protected void initializeDesktopHeaderConfigurationDefaults(Map desktopConfigMap, HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault, HashMap headerDynamicConfigurationDefault) {
        String pageActionButtonTooltipName;
        String pageActionButtonTooltip;
        String windowResizebarEnabledName;
        String resizebarEnabledContent;
        String windowTitlebarEnabledName;
        String titlebarEnabledContent;
        String windowIconPathName;
        String iconPathContent;
        String windowIconEnabledName;
        String iconEnabledContent;
        String windowActionButtonMaxName;
        String windowActionButtonMax;
        String windowActionMenuOrderName;
        String actionMenuOrderContent;
        String windowActionNoImageName;
        String actionNoImageContent;
        String desktopWindowWidthName;
        String desktopWindowWidth;
        String desktopWindowHeightName;
        String desktopWindowHeight;
        String desktopWindowHeightExpandName;
        String desktopWindowHeightExpand;
        String desktopWindowTilingName;
        String desktopWindowTiling;
        String desktopPageAjaxNavName;
        String desktopPageAjaxNav;
        String portletDecorationDefaultName;
        String portletDecoration;
        if (desktopConfigMap == null) {
            desktopConfigMap = new HashMap();
        }
        StringBuffer desktopDojoConfigContent = new StringBuffer();
        String layoutDecorationDefaultName = "decoration.layout";
        String layoutDecoration = (String)desktopConfigMap.get(layoutDecorationDefaultName);
        if (layoutDecoration != null && layoutDecoration.length() > 0) {
            this.decorationFactory.setDefaultDesktopLayoutDecoration(layoutDecoration);
        }
        if ((portletDecoration = (String)desktopConfigMap.get(portletDecorationDefaultName = "decoration.portlet")) == null || portletDecoration.length() == 0) {
            portletDecoration = this.decorationFactory.getDefaultDesktopPortletDecoration();
        }
        if (portletDecoration != null && portletDecoration.length() > 0) {
            if (this.canAddHeaderNamedResourceFragment(portletDecorationDefaultName, namedResourcesAddedFragmentsDefault, null)) {
                desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".windowDecoration = \"").append(portletDecoration).append("\";").append(EOL);
            }
            this.decorationFactory.setDefaultDesktopPortletDecoration(portletDecoration);
        }
        if ((desktopPageAjaxNav = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(desktopPageAjaxNavName = "page.ajaxnavigation"))) != null && this.canAddHeaderNamedResourceFragment(desktopPageAjaxNavName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".ajaxPageNavigation = ").append(desktopPageAjaxNav).append(";").append(EOL);
        }
        if ((desktopWindowTiling = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(desktopWindowTilingName = "window.tiling"))) != null && this.canAddHeaderNamedResourceFragment(desktopWindowTilingName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".windowTiling = ").append(desktopWindowTiling).append(";").append(EOL);
        }
        if ((desktopWindowHeightExpand = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(desktopWindowHeightExpandName = "window.heightexpand"))) != null && this.canAddHeaderNamedResourceFragment(desktopWindowHeightExpandName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".windowHeightExpand = ").append(desktopWindowHeightExpand).append(";").append(EOL);
        }
        if ((desktopWindowHeight = HeaderResourceLib.makeJSONInteger(desktopConfigMap.get(desktopWindowHeightName = "window.height"), (boolean)true)) != null && this.canAddHeaderNamedResourceFragment(desktopWindowHeightName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".windowHeight = ").append(desktopWindowHeight).append(";").append(EOL);
        }
        if ((desktopWindowWidth = HeaderResourceLib.makeJSONInteger(desktopConfigMap.get(desktopWindowWidthName = "window.width"), (boolean)true)) != null && this.canAddHeaderNamedResourceFragment(desktopWindowWidthName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".windowWidth = ").append(desktopWindowWidth).append(";").append(EOL);
        }
        ArrayList actionList = new ArrayList();
        String windowActionButtonOrderName = "window.action.button.order";
        String actionButtonOrderContent = HeaderResourceLib.makeJSONStringArray((Collection)((List)desktopConfigMap.get(windowActionButtonOrderName)), actionList);
        if (actionButtonOrderContent != null && actionButtonOrderContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowActionButtonOrderName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowActionButtonOrder").append(" = ").append(actionButtonOrderContent).append(";").append(EOL);
        }
        if ((actionNoImageContent = HeaderResourceLib.makeJSONStringArray((Collection)((List)desktopConfigMap.get(windowActionNoImageName = "window.action.noimage")), actionList)) != null && actionNoImageContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowActionNoImageName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowActionNoImage").append(" = ").append(actionNoImageContent).append(";").append(EOL);
        }
        if ((actionMenuOrderContent = HeaderResourceLib.makeJSONStringArray((Collection)((List)desktopConfigMap.get(windowActionMenuOrderName = "window.action.menu.order")), actionList)) != null && actionMenuOrderContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowActionMenuOrderName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowActionMenuOrder").append(" = ").append(actionMenuOrderContent).append(";").append(EOL);
        }
        headerDynamicConfigurationDefault.put("desktop.window.action", actionList);
        String windowActionButtonTooltipName = "window.action.button.tooltip";
        String windowActionButtonTooltip = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(windowActionButtonTooltipName));
        if (windowActionButtonTooltip != null && this.canAddHeaderNamedResourceFragment(windowActionButtonTooltipName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowActionButtonTooltip").append(" = ").append(windowActionButtonTooltip).append(";").append(EOL);
        }
        if ((windowActionButtonMax = HeaderResourceLib.makeJSONInteger(desktopConfigMap.get(windowActionButtonMaxName = "window.action.button.maximum"), (boolean)false)) != null && this.canAddHeaderNamedResourceFragment(windowActionButtonMaxName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowActionButtonMax").append(" = ").append(windowActionButtonMax).append(";").append(EOL);
        }
        if ((iconEnabledContent = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(windowIconEnabledName = "window.icon.enabled"))) != null && iconEnabledContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowIconEnabledName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowIconEnabled").append(" = ").append(iconEnabledContent).append(";").append(EOL);
        }
        if ((iconPathContent = (String)desktopConfigMap.get(windowIconPathName = "window.icon.path")) != null && iconPathContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowIconPathName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowIconPath").append(" = \"").append(iconPathContent).append("\";").append(EOL);
        }
        if ((titlebarEnabledContent = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(windowTitlebarEnabledName = "window.titlebar.enabled"))) != null && titlebarEnabledContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowTitlebarEnabledName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowTitlebar").append(" = ").append(titlebarEnabledContent).append(";").append(EOL);
        }
        if ((resizebarEnabledContent = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(windowResizebarEnabledName = "window.resizebar.enabled"))) != null && resizebarEnabledContent.length() > 0 && this.canAddHeaderNamedResourceFragment(windowResizebarEnabledName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed.").append("windowTitlebar").append(" = ").append(resizebarEnabledContent).append(";").append(EOL);
        }
        if ((pageActionButtonTooltip = HeaderResourceLib.makeJSONBoolean(desktopConfigMap.get(pageActionButtonTooltipName = "page.action.button.tooltip"))) != null && this.canAddHeaderNamedResourceFragment(pageActionButtonTooltipName, namedResourcesAddedFragmentsDefault, null)) {
            desktopDojoConfigContent.append("    ").append("djConfig.jetspeed").append(".pageActionButtonTooltip = ").append(pageActionButtonTooltip).append(";").append(EOL);
        }
        if (desktopDojoConfigContent.length() > 0) {
            namedResourcesDefault.put("header.dojo.config", desktopDojoConfigContent.toString());
        }
        StringBuffer desktopInitScript = new StringBuffer();
        desktopInitScript.append("    function doRender(bindArgs,portletEntityId) { ");
        desktopInitScript.append("jetspeed.doRender(bindArgs,portletEntityId); }").append(EOL);
        desktopInitScript.append("    function doAction(bindArgs,portletEntityId) { ");
        desktopInitScript.append("jetspeed.doAction(bindArgs,portletEntityId); }").append(EOL);
        desktopInitScript.append("    dojo.addOnLoad( jetspeed.initializeDesktop );").append(EOL);
        if (this.canAddHeaderNamedResourceFragment("desktop.init", namedResourcesAddedFragmentsDefault, null)) {
            namedResourcesDefault.put("header.desktop.init", desktopInitScript.toString());
            this.setNamedHeaderResourceProperties("header.desktop.init", "script-start", null, headerDynamicConfigurationDefault);
        }
    }

    protected void initializeDojoHeaderConfigurationDefaults(Map dojoConfigMap, HashMap namedResourcesDefault, HashMap namedResourcesAddedFragmentsDefault, HashMap headerDynamicConfigurationDefault) {
        List dojoRequiresModules;
        List dojoModulesNamespace;
        List dojoModulesPath;
        String dojoEnable;
        if (dojoConfigMap == null) {
            dojoConfigMap = new HashMap();
        }
        String[] registryContent = new String[]{null};
        String dojoEnableName = "dojo.enable";
        Object dojoEnableObj = dojoConfigMap.get(dojoEnableName);
        String string = dojoEnable = dojoEnableObj == null ? (String)null : dojoEnableObj.toString();
        if (dojoEnable == null || !dojoEnable.equals("true")) {
            dojoEnable = "false";
        }
        headerDynamicConfigurationDefault.put(dojoEnableName, dojoEnable);
        String dojoPath = (String)dojoConfigMap.get("dojo.path");
        if (dojoPath == null || dojoPath.length() == 0) {
            dojoPath = "/javascript/dojo/";
        }
        headerDynamicConfigurationDefault.put("dojo.path", dojoPath);
        boolean dojoDebugEnabled = false;
        String dojoParamDebug = (String)dojoConfigMap.get("dojo.parameter.isDebug");
        String dojoParamDebugAtAllCosts = null;
        if (dojoParamDebug != null) {
            dojoParamDebug = dojoParamDebug.toLowerCase();
        }
        if (dojoParamDebug == null || dojoParamDebug.length() == 0 || dojoParamDebug.equals("false")) {
            dojoParamDebug = null;
        } else if (dojoParamDebug.equals("true")) {
            dojoDebugEnabled = true;
            dojoParamDebugAtAllCosts = (String)dojoConfigMap.get("dojo.parameter.debugAtAllCosts");
            if (dojoParamDebugAtAllCosts != null && !(dojoParamDebugAtAllCosts = dojoParamDebugAtAllCosts.toLowerCase()).equals("true")) {
                dojoParamDebugAtAllCosts = null;
            }
        }
        String dojoParamPreventBackBtnFix = (String)dojoConfigMap.get("dojo.parameter.preventBackButtonFix");
        String dojoParams = (String)dojoConfigMap.get("dojo.parameters");
        if (dojoParamDebug != null || dojoParamDebugAtAllCosts != null || dojoParamPreventBackBtnFix != null || dojoParams != null) {
            StringBuffer dojoConfigContent = new StringBuffer();
            boolean addedMembers = false;
            if (dojoParams != null && dojoParams.length() > 0) {
                dojoConfigContent.append(dojoParams);
                addedMembers = true;
            }
            if (dojoParamDebug != null && dojoParamDebug.length() > 0) {
                if (addedMembers) {
                    dojoConfigContent.append(", ");
                }
                dojoConfigContent.append("isDebug: ").append(dojoParamDebug);
                addedMembers = true;
            }
            if (dojoParamDebugAtAllCosts != null && dojoParamDebugAtAllCosts.length() > 0) {
                if (addedMembers) {
                    dojoConfigContent.append(", ");
                }
                dojoConfigContent.append("debugAtAllCosts: ").append(dojoParamDebugAtAllCosts);
                addedMembers = true;
            }
            if (dojoParamPreventBackBtnFix != null && dojoParamPreventBackBtnFix.length() > 0) {
                if (addedMembers) {
                    dojoConfigContent.append(", ");
                }
                dojoConfigContent.append("preventBackButtonFix: ").append(dojoParamPreventBackBtnFix);
                addedMembers = true;
            }
            if (addedMembers) {
                dojoConfigContent.append(", ");
            }
            dojoConfigContent.append("jetspeed").append(": {}");
            addedMembers = true;
            if (this.canAddHeaderNamedResourceFragment("dojo.parameters", namedResourcesAddedFragmentsDefault, registryContent)) {
                String dojoParamContent = dojoConfigContent.toString();
                if (registryContent[0] != null) {
                    dojoParamContent = registryContent[0];
                }
                if (dojoParamContent.length() > 0) {
                    namedResourcesDefault.put("header.dojo.parameters", "    var djConfig = {" + dojoParamContent + "};" + EOL);
                }
            }
            this.registerAndOrderNamedHeaderResource("header.dojo.parameters", "script-start", dojoEnableName, headerDynamicConfigurationDefault);
        }
        this.registerAndOrderNamedHeaderResource("header.dojo.preinit", null, dojoEnableName, headerDynamicConfigurationDefault);
        this.registerAndOrderNamedHeaderResource("header.dojo.config", null, dojoEnableName, headerDynamicConfigurationDefault);
        this.registerAndOrderNamedHeaderResource("header.dojo.init", "script-tag", dojoEnableName, headerDynamicConfigurationDefault);
        List dojoRequiresCore = (List)dojoConfigMap.get("dojo.requires.core");
        if (dojoRequiresCore != null && dojoRequiresCore.size() > 0) {
            StringBuffer dojoRequiresContent = new StringBuffer();
            for (String dojoReq : dojoRequiresCore) {
                if (dojoReq == null || dojoReq.length() <= 0 || !this.canAddHeaderNamedResourceFragment(dojoReq, namedResourcesAddedFragmentsDefault, registryContent)) continue;
                if (registryContent[0] != null) {
                    String dojoReqFromRegistry = HeaderResourceLib.makeJavascriptStatement((String)registryContent[0], (String)"    ", (boolean)true);
                    if (dojoReqFromRegistry.length() <= 0) continue;
                    dojoRequiresContent.append(registryContent[0]);
                    continue;
                }
                dojoRequiresContent.append("    dojo.require(\"").append(dojoReq).append("\");").append(EOL);
            }
            namedResourcesDefault.put("header.dojo.requires.core", dojoRequiresContent.toString());
            this.registerAndOrderNamedHeaderResource("header.dojo.requires.core", null, dojoEnableName, headerDynamicConfigurationDefault);
        }
        if ((dojoModulesPath = (List)dojoConfigMap.get("dojo.modules.path")) != null && dojoModulesPath.size() > 0) {
            StringBuffer dojoModulesPathContent = new StringBuffer();
            boolean addedContent = false;
            for (String dojoModule : dojoModulesPath) {
                if (dojoModule == null || dojoModule.length() <= 0 || !this.canAddHeaderNamedResourceFragment(dojoModule, namedResourcesAddedFragmentsDefault, registryContent)) continue;
                String dojoModuleContent = null;
                dojoModuleContent = registryContent[0] != null ? registryContent[0] : dojoModule;
                if ((dojoModuleContent = HeaderResourceLib.makeJavascriptStatement((String)dojoModuleContent, (String)"    ", (boolean)true)).length() <= 0) continue;
                dojoModulesPathContent.append(dojoModuleContent);
                addedContent = true;
            }
            if (addedContent) {
                namedResourcesDefault.put("header.dojo.modules.path", dojoModulesPathContent.toString());
                this.registerAndOrderNamedHeaderResource("header.dojo.modules.path", null, dojoEnableName, headerDynamicConfigurationDefault);
            }
        }
        if ((dojoModulesNamespace = (List)dojoConfigMap.get("dojo.modules.namespace")) != null && dojoModulesNamespace.size() > 0) {
            StringBuffer dojoModulesNamespaceContent = new StringBuffer();
            boolean addedContent = false;
            for (String dojoModuleWidget : dojoModulesNamespace) {
                if (dojoModuleWidget == null || dojoModuleWidget.length() <= 0 || !this.canAddHeaderNamedResourceFragment(dojoModuleWidget, namedResourcesAddedFragmentsDefault, registryContent)) continue;
                String dojoModuleContent = null;
                dojoModuleContent = registryContent[0] != null ? registryContent[0] : dojoModuleWidget;
                if ((dojoModuleContent = HeaderResourceLib.makeJavascriptStatement((String)dojoModuleContent, (String)"    ", (boolean)true)).length() <= 0) continue;
                dojoModulesNamespaceContent.append(dojoModuleContent);
                addedContent = true;
            }
            if (addedContent) {
                namedResourcesDefault.put("header.dojo.modules.namespace", dojoModulesNamespaceContent.toString());
            }
        }
        if ((dojoRequiresModules = (List)dojoConfigMap.get("dojo.requires.modules")) != null && dojoRequiresModules.size() > 0) {
            HashMap<String, String> addedReqs = null;
            if (dojoDebugEnabled) {
                addedReqs = new HashMap<String, String>();
            }
            StringBuffer dojoRequiresContent = new StringBuffer();
            for (String dojoReq : dojoRequiresModules) {
                if (dojoReq == null || dojoReq.length() <= 0 || !this.canAddHeaderNamedResourceFragment(dojoReq, namedResourcesAddedFragmentsDefault, registryContent)) continue;
                if (registryContent[0] != null) {
                    String dojoReqFromRegistry = HeaderResourceLib.makeJavascriptStatement((String)registryContent[0], (String)"    ", (boolean)true);
                    if (dojoReqFromRegistry.length() <= 0) continue;
                    dojoRequiresContent.append(registryContent[0]);
                    continue;
                }
                dojoRequiresContent.append("    dojo.require(\"").append(dojoReq).append("\");").append(EOL);
                if (!dojoDebugEnabled) continue;
                addedReqs.put(dojoReq, dojoReq);
            }
            if (dojoDebugEnabled && addedReqs.get("jetspeed.desktop.debug") == null) {
                dojoRequiresContent.append("    dojo.require(\"").append("jetspeed.desktop.debug").append("\");").append(EOL);
            }
            namedResourcesDefault.put("header.dojo.requires.modules", dojoRequiresContent.toString());
            this.registerAndOrderNamedHeaderResource("header.dojo.requires.modules", null, dojoEnableName, headerDynamicConfigurationDefault);
        }
        this.registerAndOrderNamedHeaderResource("header.dojo.writeincludes", "script-start", dojoEnableName, headerDynamicConfigurationDefault);
        this.registerAndOrderNamedHeaderResource("header.dojo.modules.namespace", "script-start", dojoEnableName, headerDynamicConfigurationDefault);
        this.setNamedHeaderResourceProperties("header.dojo.style.bodyexpand", "style", dojoEnableName, headerDynamicConfigurationDefault);
        this.setNamedHeaderResourceProperties("header.dojo.style.bodyexpand.noscroll", "style", dojoEnableName, headerDynamicConfigurationDefault);
    }

    public void build(RequestContext context) throws JetspeedException, IOException {
        Map existingNamedResources;
        ContentPage page = context.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin ContentPageAggregator.build");
        }
        ContentFragment root = page.getRootFragment();
        if (root == null) {
            throw new JetspeedException("No root ContentFragment found in ContentPage");
        }
        Map dynamicConfigDefault = this.getHeaderDynamicConfigurationDefault();
        Map namedResourcesDefault = this.getHeaderNamedResourcesDefault();
        Map namedResourcesAddedFragmentsDefault = this.getHeaderNamedResourcesAddedFragmentsDefault();
        if ((dynamicConfigDefault != null || namedResourcesDefault != null || namedResourcesAddedFragmentsDefault != null) && (existingNamedResources = (Map)context.getAttribute("org.apache.jetspeed.headernamedresource")) == null) {
            if (dynamicConfigDefault == null) {
                context.setAttribute("org.apache.jetspeed.headerconfiguration", new HashMap());
            } else {
                HashMap dynamicConfig = new HashMap();
                for (Map.Entry hConfigEntry : dynamicConfigDefault.entrySet()) {
                    Object hConfigKey = hConfigEntry.getKey();
                    Object hConfigVal = hConfigEntry.getValue();
                    if (hConfigVal instanceof Map) {
                        dynamicConfig.put(hConfigKey, new HashMap((Map)hConfigVal));
                        continue;
                    }
                    if (hConfigVal instanceof List) {
                        dynamicConfig.put(hConfigKey, new ArrayList((List)hConfigVal));
                        continue;
                    }
                    dynamicConfig.put(hConfigKey, (Cloneable)hConfigVal);
                }
                context.setAttribute("org.apache.jetspeed.headerconfiguration", dynamicConfig);
            }
            if (namedResourcesDefault != null) {
                context.setAttribute("org.apache.jetspeed.headernamedresource", new HashMap(namedResourcesDefault));
            }
            if (namedResourcesAddedFragmentsDefault != null) {
                context.setAttribute("org.apache.jetspeed.headernamedresourceaddedfragments", new HashMap(namedResourcesAddedFragmentsDefault));
            }
        }
        if (this.getHeaderResourceRegistry() != null) {
            context.setAttribute("org.apache.jetspeed.headernamedresourceregistry", (Object)this.getHeaderResourceRegistry());
        }
    }

    protected PortletFactory getPortletFactory() {
        return this.factory;
    }

    protected HeaderResourceFactory getHeaderResourceFactory() {
        return this.headerResourceFactory;
    }

    protected boolean isDesktop() {
        return this.isDesktop;
    }

    protected Map getHeaderConfiguration() {
        return this.headerConfiguration;
    }

    protected Map getHeaderResourceRegistry() {
        return this.headerResourceRegistry;
    }

    protected Map getHeaderDynamicConfigurationDefault() {
        return this.headerDynamicConfigurationDefault;
    }

    protected Map getHeaderNamedResourcesDefault() {
        return this.headerNamedResourcesDefault;
    }

    protected Map getHeaderNamedResourcesAddedFragmentsDefault() {
        return this.headerNamedResourcesAddedFragmentsDefault;
    }

    protected BasePortalURL getBaseUrlAccess() {
        return this.baseUrlAccess;
    }

    public void renderContent(RequestContext context, ContentFragment root) throws JetspeedException, IOException {
    }
}

