/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.aggregator.impl;

import java.io.IOException;
import java.util.List;
import org.apache.jetspeed.aggregator.PageAggregator;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.aggregator.impl.BaseAggregatorImpl;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.state.NavigationalState;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;

public class PageAggregatorImpl
extends BaseAggregatorImpl
implements PageAggregator {
    public PageAggregatorImpl(PortletRenderer renderer) {
        super(renderer);
    }

    public void build(RequestContext context) throws JetspeedException, IOException {
        ContentPage page = context.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin ContentPageAggregator.build");
        }
        ContentFragment root = page.getRootFragment();
        if (root == null) {
            throw new JetspeedException("No root ContentFragment found in ContentPage");
        }
        NavigationalState nav = context.getPortalURL().getNavigationalState();
        PortletWindow window = nav.getMaximizedWindow();
        if (null != window) {
            this.renderMaximizedWindow(context, page, root, window);
        } else {
            this.aggregateAndRender(root, context, page);
        }
        this.renderContent(context, root);
        if (null != window) {
            window.removeAttribute("org.apache.jetspeed.maximized.Fragment");
            window.removeAttribute("org.apache.jetspeed.maximized.Layout");
        }
        this.releaseBuffers(root, context);
    }

    protected void aggregateAndRender(ContentFragment f, RequestContext context, ContentPage page) {
        List contentFragments = f.getFragments();
        if (contentFragments != null && !contentFragments.isEmpty()) {
            for (ContentFragment child : contentFragments) {
                if ("hidden".equals(f.getState())) continue;
                this.aggregateAndRender(child, context, page);
            }
        }
        this.renderer.renderNow(f, context);
    }
}

